/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.internal.proxy.core.IConfigurationContributor;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.designtime.internal.view.DTComponentIntrospector;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataLoader;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.AbstractTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletDocumentFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.ELProxyContributor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.IFaceletTagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.Messages;
import org.eclipse.jst.jsf.facelet.core.internal.registry.MetadataAttributeAdvisor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTag;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTagAttribute;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FullyQualifiedClass;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.ComponentTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.ConverterTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.HandlerTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.SourceTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib_1_0.ValidatorTagDefn;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.ComponentTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.ConverterTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.FaceletTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.HandlerTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.NoArchetypeFaceletTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.SourceTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.ValidatorTag;

class FaceletTagResolvingStrategy
extends AbstractTagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper, String>
implements IFaceletTagResolvingStrategy {
    public static final String ID = "org.eclipse.jst.jsf.facelet.core.FaceletTagResolvingStrategy";
    private final IProject _project;
    private final FaceletDocumentFactory _factory;
    private final ViewMetadataLoader _viewLoader;

    public FaceletTagResolvingStrategy(IProject project, FaceletDocumentFactory factory) {
        this._project = project;
        this._factory = factory;
        this._viewLoader = new ViewMetadataLoader(project);
    }

    public final String getId() {
        return ID;
    }

    public final ITagElement resolve(IFaceletTagResolvingStrategy.TLDWrapper tldWrapper) {
        return this.createFaceletTag(tldWrapper.getUri(), tldWrapper.getTagDefn());
    }

    public final String getDisplayName() {
        return Messages.FaceletTagResolvingStrategy_FACELET_TAG_RESOLVER_DISPLAY_NAME;
    }

    private FaceletTag createFaceletTag(String uri, FaceletTaglibTag tagDefn) {
        String tagName = tagDefn.getTagName();
        TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)uri, (String)tagName);
        MetadataAttributeAdvisor advisor = new MetadataAttributeAdvisor(tagId, this._viewLoader, (List<FaceletTaglibTagAttribute>)tagDefn.getAttribute());
        if (tagDefn instanceof ComponentTagDefn) {
            ComponentTagDefn componentTagDefn = (ComponentTagDefn)((Object)tagDefn);
            String componentType = componentTagDefn.getComponentType();
            String componentClass = DTComponentIntrospector.findComponentClass((String)componentType, (IProject)this._project);
            ComponentTypeInfo typeInfo = null;
            if (componentClass != null) {
                typeInfo = DTComponentIntrospector.getComponent((String)componentType, (String)componentClass, (IProject)this._project, (IConfigurationContributor[])new IConfigurationContributor[]{new ELProxyContributor(this._project)});
            }
            return new ComponentTag(uri, tagName, typeInfo, FaceletTagResolvingStrategy.safeGetString(componentTagDefn.getHandlerClass()), this._factory, (IAttributeAdvisor)advisor);
        }
        if (tagDefn instanceof ValidatorTagDefn) {
            ValidatorTypeInfo typeInfo;
            ValidatorTagDefn validatorTagDefn = (ValidatorTagDefn)((Object)tagDefn);
            String validatorId = validatorTagDefn.getValidatorId();
            if (validatorId != null) {
                String validatorClass = DTComponentIntrospector.findValidatorClass((String)validatorId, (IProject)this._project);
                typeInfo = new ValidatorTypeInfo(validatorClass, validatorId);
            } else {
                typeInfo = ValidatorTypeInfo.UNKNOWN;
            }
            return new ValidatorTag(uri, tagName, typeInfo, FaceletTagResolvingStrategy.safeGetString(validatorTagDefn.getHandlerClass()), this._factory, (IAttributeAdvisor)advisor);
        }
        if (tagDefn instanceof ConverterTagDefn) {
            ConverterTypeInfo typeInfo;
            ConverterTagDefn converterTagDefn = (ConverterTagDefn)((Object)tagDefn);
            String converterId = converterTagDefn.getConverterId();
            if (converterId != null) {
                String converterClass = DTComponentIntrospector.findConverterClass((String)converterId, (IProject)this._project);
                typeInfo = new ConverterTypeInfo(converterClass, converterId);
            } else {
                typeInfo = ConverterTypeInfo.UNKNOWN;
            }
            return new ConverterTag(uri, tagName, typeInfo, FaceletTagResolvingStrategy.safeGetString(converterTagDefn.getHandlerClass()), this._factory, (IAttributeAdvisor)advisor);
        }
        if (tagDefn instanceof HandlerTagDefn) {
            String handlerClass = FaceletTagResolvingStrategy.safeGetString(((HandlerTagDefn)((Object)tagDefn)).getHandlerClass());
            return new HandlerTag(uri, tagName, null, handlerClass, this._factory, (IAttributeAdvisor)advisor);
        }
        if (tagDefn instanceof SourceTagDefn) {
            String source = ((SourceTagDefn)((Object)tagDefn)).getSource();
            return new SourceTag(uri, tagName, source, this._factory, advisor);
        }
        return this.handleNewFaceletTagDefn(uri, tagName, tagDefn, advisor);
    }

    private FaceletTag handleNewFaceletTagDefn(String uri, String tagName, FaceletTaglibTag tagDefn, IAttributeAdvisor advisor) {
        FullyQualifiedClass handlerClassElement = tagDefn.getHandlerClassElement();
        return new NoArchetypeFaceletTag(uri, tagName, FaceletTagResolvingStrategy.safeGetString(handlerClassElement != null ? FaceletTagResolvingStrategy.safeGetString(handlerClassElement.getValue()) : null), this._factory, advisor);
    }

    private static String safeGetString(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        if ("".equals(trimmed)) {
            return null;
        }
        return trimmed;
    }
}

