/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.launchbar.ui.controls.internal.LaunchBarListViewer;
import org.eclipse.launchbar.ui.controls.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.progress.WorkbenchJob;

public class FilterControl
extends Composite {
    protected Text filterText;
    protected LaunchBarListViewer listViewer;
    protected ViewerFilter patternFilter;
    protected String initialText = "";
    protected String patternText = null;
    private Job refreshJob;
    protected Composite parent;

    public FilterControl(Composite parent) {
        super(parent, 0);
        this.parent = parent;
        this.patternFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                String text = ((ILabelProvider)FilterControl.this.listViewer.getLabelProvider()).getText(element);
                if (FilterControl.this.patternText == null) {
                    return true;
                }
                String trim = FilterControl.this.patternText.trim();
                if (trim.isEmpty()) {
                    return true;
                }
                if (text == null) {
                    return false;
                }
                if (text.contains(trim)) {
                    return true;
                }
                return text.toLowerCase().contains(trim.toLowerCase());
            }
        };
        this.init();
    }

    protected void init() {
        this.createControl(this, 0);
        this.createRefreshJob();
        this.setInitialText(Messages.FilterControl_0);
        this.setFont(this.parent.getFont());
    }

    protected void createControl(Composite parent, int treeStyle) {
        this.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        if (parent.getLayout() instanceof GridLayout) {
            this.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        }
        Composite fc = this.createFilterControls(parent);
        fc.setLayoutData((Object)new GridData(4, 1, true, false));
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        return parent;
    }

    public Control attachListViewer(LaunchBarListViewer listViewer) {
        this.listViewer = listViewer;
        listViewer.getControl().addDisposeListener(e -> {
            boolean bl = this.refreshJob.cancel();
        });
        listViewer.addFilter(this.patternFilter);
        return listViewer.getControl();
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.getVisible();
        if (oldVisible && !visible && this.listViewer != null && this.filterText.isFocusControl()) {
            this.listViewer.setFocus();
        }
        if (this.getLayoutData() instanceof GridData) {
            ((GridData)this.getLayoutData()).heightHint = visible ? -1 : 0;
        }
        super.setVisible(visible);
    }

    protected WorkbenchJob doCreateRefreshJob() {
        return new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (FilterControl.this.listViewer == null) {
                    return Status.CANCEL_STATUS;
                }
                if (FilterControl.this.listViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                FilterControl.this.updatePatternText();
                if (FilterControl.this.patternText == null) {
                    return Status.OK_STATUS;
                }
                Control redrawControl = FilterControl.this.listViewer.getControl();
                try {
                    redrawControl.setRedraw(false);
                    FilterControl.this.listViewer.setHistorySupported(FilterControl.this.patternText == null || FilterControl.this.patternText.isEmpty());
                    FilterControl.this.listViewer.refresh(true);
                    FilterControl.this.updateListSelection(false);
                    FilterControl.this.filterText.setFocus();
                }
                finally {
                    redrawControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilterControl.this.filterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(FilterControl.this.initialText) ? FilterControl.this.initialText : NLS.bind((String)Messages.FilterControl_1, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                return FilterControl.this.listViewer.getItemCount();
            }
        });
        this.filterText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (FilterControl.this.filterText.getText().equals(FilterControl.this.initialText)) {
                    FilterControl.this.setFilterText("");
                }
            }
        });
        this.filterText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (FilterControl.this.filterText.getText().equals(FilterControl.this.initialText)) {
                    FilterControl.this.clearText();
                }
            }
        });
        this.filterText.addTraverseListener(e -> {
            if (e.detail == 4) {
                e.doit = false;
                this.listViewer.setFocus();
                this.updateListSelection(true);
            } else if (e.detail == 64) {
                this.listViewer.setFocus();
                this.updateListSelection(false);
            } else if (e.detail == 2) {
                this.listViewer.setDefaultSelection(new StructuredSelection());
                e.doit = false;
            }
        });
        this.filterText.addModifyListener(e -> this.textChanged());
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (e.detail == 256) {
                        FilterControl.this.clearText();
                    }
                }
            });
        }
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
    }

    protected void updateListSelection(boolean enter) {
        if (this.listViewer.getItemCount() == 0) {
            if (enter) {
                Display.getCurrent().beep();
            }
        } else {
            StructuredSelection sel = this.patternText != null && !this.patternText.trim().isEmpty() ? new StructuredSelection(this.listViewer.getTopFilteredElement()) : new StructuredSelection(this.listViewer.getTopElement());
            if (enter) {
                this.listViewer.setDefaultSelection(sel);
            } else {
                this.listViewer.setSelection((ISelection)sel);
            }
        }
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2436);
    }

    protected void textChanged() {
        String old = this.patternText;
        this.updatePatternText();
        if (this.patternText != null && old == null && this.patternText.isEmpty()) {
            return;
        }
        if (this.patternText == old) {
            return;
        }
        this.refreshJob.cancel();
        this.refreshJob.schedule(this.getRefreshJobDelay());
    }

    protected long getRefreshJobDelay() {
        return 200L;
    }

    public void setBackground(Color background) {
        super.setBackground(background);
    }

    protected void clearText() {
        this.setFilterText("");
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public LaunchBarListViewer getViewer() {
        return this.listViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        if (this.filterText != null) {
            this.filterText.setMessage(text);
            if (this.filterText.isFocusControl()) {
                this.setFilterText(this.initialText);
                this.textChanged();
            } else {
                this.getDisplay().asyncExec(() -> {
                    if (!this.filterText.isDisposed() && this.filterText.isFocusControl()) {
                        this.setFilterText(this.initialText);
                        this.textChanged();
                    }
                });
            }
        } else {
            this.setFilterText(this.initialText);
            this.textChanged();
        }
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    private void updatePatternText() {
        boolean initial;
        String text = this.getFilterString();
        boolean bl = initial = this.initialText != null && this.initialText.equals(text);
        if (initial) {
            this.patternText = null;
        } else if (text != null) {
            this.patternText = text;
        }
    }
}

