/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.app;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.SocketChannel;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.m2m.qvt.oml.debug.core.app.SocketUtil;
import org.eclipse.m2m.qvt.oml.debug.core.app.VMServer;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMRequest;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMResponse;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.VMTerminateRequest;

abstract class AbstractRequestProcessor {
    private boolean fTerminated;
    private InputStream fRequestStream;
    private OutputStream fResponseStream;
    private Socket fRequestSocket;

    public AbstractRequestProcessor(Socket requestSocket) throws IOException {
        if (requestSocket == null || !requestSocket.isConnected() || requestSocket.isClosed()) {
            throw new IllegalArgumentException("Socket not connected or closed");
        }
        if (requestSocket.getChannel() == null) {
            throw new IllegalArgumentException("Requires a socket with open channel");
        }
        this.fRequestStream = new BufferedInputStream(requestSocket.getInputStream());
        this.fResponseStream = new BufferedOutputStream(requestSocket.getOutputStream());
        this.fRequestSocket = requestSocket;
        this.fTerminated = false;
    }

    public void run() throws IOException {
        ObjectInputStream requestObjects = null;
        ObjectOutputStream responseObjects = null;
        try {
            responseObjects = new ObjectOutputStream(this.fResponseStream);
            requestObjects = new ObjectInputStream(this.fRequestStream);
            while (!this.fTerminated) {
                VMResponse response;
                VMRequest request;
                block19: {
                    Object rawRequest;
                    try {
                        rawRequest = requestObjects.readObject();
                    }
                    catch (AsynchronousCloseException e) {
                        continue;
                    }
                    catch (SocketException e) {
                        e.printStackTrace();
                        this.fTerminated = true;
                        break;
                    }
                    catch (IOException e) {
                        if (e instanceof EOFException) {
                            QVTODebugCore.TRACE.trace("VM Server - Client disconnected, going to shutdown");
                            this.fTerminated = true;
                            break;
                        }
                        rawRequest = null;
                        QVTODebugCore.log(e);
                    }
                    catch (ClassNotFoundException e) {
                        rawRequest = null;
                        VMResponse vMResponse = VMResponse.createERROR();
                    }
                    request = this.validateRequestObject(rawRequest);
                    if (request != null) {
                        try {
                            response = this.processRequest(request);
                            break block19;
                        }
                        catch (CoreException e) {
                            System.err.println(e.getStatus());
                            this.fTerminated = true;
                            break;
                        }
                    }
                    response = VMResponse.createERROR();
                }
                try {
                    responseObjects.writeObject(response);
                    responseObjects.flush();
                }
                catch (IOException e) {
                    this.reportSendReponseError(response, e);
                }
                if (!(request instanceof VMTerminateRequest)) continue;
                this.fTerminated = true;
                break;
            }
        }
        catch (Throwable throwable) {
            if (responseObjects != null) {
                SocketUtil.close(responseObjects);
            }
            if (requestObjects != null) {
                SocketUtil.close(requestObjects);
            }
            throw throwable;
        }
        if (responseObjects != null) {
            SocketUtil.close(responseObjects);
        }
        if (requestObjects != null) {
            SocketUtil.close(requestObjects);
        }
    }

    protected void postTerminate() {
    }

    protected abstract VMResponse processRequest(VMRequest var1) throws CoreException;

    private VMRequest validateRequestObject(Object rawRequest) {
        if (!(rawRequest instanceof VMRequest)) {
            QVTODebugCore.TRACE.trace("Invalid VM request: " + rawRequest);
            return null;
        }
        return (VMRequest)rawRequest;
    }

    private void reportSendReponseError(VMResponse response, IOException e) {
        QVTODebugCore.TRACE.catching(VMServer.class, "sendResponse", e);
        QVTODebugCore.log(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        AbstractRequestProcessor abstractRequestProcessor = this;
        synchronized (abstractRequestProcessor) {
            this.fTerminated = true;
            SocketChannel channel = this.fRequestSocket.getChannel();
            assert (channel != null);
            try {
                channel.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

