/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ParallelRunner
extends ArrayList<Runnable> {
    private static final long serialVersionUID = 1L;

    public ParallelRunner() {
    }

    public ParallelRunner(Collection<? extends Runnable> c) {
        super(c);
    }

    public ParallelRunner(int initialCapacity) {
        super(initialCapacity);
    }

    public void run(ExecutorService executorService, long timeout) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(this.size());
        for (final Runnable runnable : this) {
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    finally {
                        latch.countDown();
                    }
                }
            });
        }
        latch.await(timeout, TimeUnit.MILLISECONDS);
    }
}

