/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.NameVersionDescriptor;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEPreferencesManager;
import org.eclipse.pde.internal.core.TargetDefinitionManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.DirectoryBundleContainer;
import org.eclipse.pde.internal.core.target.ExternalFileTargetHandle;
import org.eclipse.pde.internal.core.target.FeatureBundleContainer;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.LocalTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.ProfileBundleContainer;
import org.eclipse.pde.internal.core.target.RemoteTargetHandle;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.WorkspaceFileTargetHandle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class TargetPlatformService
implements ITargetPlatformService {
    private static ITargetPlatformService fgDefault;
    private static Map<URI, ExternalFileTargetHandle> fExtTargetHandles;
    private final AtomicReference<ITargetDefinition> fWorkspaceTarget = new AtomicReference();
    private StringBuilder fVMArguments;

    private TargetPlatformService() {
    }

    public static synchronized ITargetPlatformService getDefault() {
        if (fgDefault == null) {
            fgDefault = new TargetPlatformService();
        }
        return fgDefault;
    }

    @Override
    public void deleteTarget(ITargetHandle handle) throws CoreException {
        if (handle instanceof ExternalFileTargetHandle) {
            fExtTargetHandles.remove(((ExternalFileTargetHandle)handle).getLocation());
        }
        ((AbstractTargetHandle)handle).delete();
        TargetPlatformHelper.getTargetDefinitionMap().remove(handle);
        TargetPlatformService.scheduleEvent("org/eclipse/pde/core/target/TargetEvents/targetDeleted", handle);
    }

    @Override
    public ITargetHandle getTarget(IFile file) {
        return new WorkspaceFileTargetHandle(file);
    }

    @Override
    public ITargetHandle getTarget(String memento) throws CoreException {
        block18: {
            try {
                URI uri = new URI(memento);
                String scheme = uri.getScheme();
                if (scheme == null) break block18;
                switch (scheme) {
                    case "resource": {
                        return WorkspaceFileTargetHandle.restoreHandle(uri);
                    }
                    case "local": {
                        return LocalTargetHandle.restoreHandle(uri);
                    }
                    case "file": {
                        return ExternalFileTargetHandle.restoreHandle(uri);
                    }
                    case "remote": {
                        return RemoteTargetHandle.get(memento.substring("remote".length() + 1));
                    }
                }
            }
            catch (URISyntaxException e) {
                throw new CoreException(Status.error((String)Messages.TargetPlatformService_0, (Throwable)e));
            }
        }
        throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetPlatformService_1, (Object)memento, (Object)Stream.of("resource", "local", "file", "remote").collect(Collectors.joining(", "))), null));
    }

    @Override
    public ITargetHandle getTarget(URI uri) {
        if (fExtTargetHandles == null) {
            fExtTargetHandles = new LinkedHashMap<URI, ExternalFileTargetHandle>(10);
        }
        if (fExtTargetHandles.containsKey(uri)) {
            return fExtTargetHandles.get(uri);
        }
        ExternalFileTargetHandle externalTarget = new ExternalFileTargetHandle(uri);
        fExtTargetHandles.put(uri, externalTarget);
        return externalTarget;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ITargetHandle[] getTargets(IProgressMonitor monitor) {
        List<ITargetHandle> local = this.findLocalTargetDefinitions();
        List<WorkspaceFileTargetHandle> ws = this.findWorkspaceTargetDefinitions();
        local.addAll(ws);
        if (fExtTargetHandles != null) {
            Collection<ExternalFileTargetHandle> externalTargets = fExtTargetHandles.values();
            for (ExternalFileTargetHandle target : externalTargets) {
                if (!target.exists()) continue;
                local.add(target);
            }
            return local.toArray(new ITargetHandle[local.size()]);
        } else {
            PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
            String memento = preferences.getString("workspace_target_handle");
            if (memento == null || memento.length() == 0 || memento.equals("NO_TARGET")) return local.toArray(new ITargetHandle[local.size()]);
            try {
                URI uri = new URI(memento);
                String scheme = uri.getScheme();
                if (!"file".equals(scheme)) return local.toArray(new ITargetHandle[local.size()]);
                ITargetHandle target = this.getTarget(uri);
                local.add(target);
                return local.toArray(new ITargetHandle[local.size()]);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return local.toArray(new ITargetHandle[local.size()]);
    }

    private List<ITargetHandle> findLocalTargetDefinitions() {
        IPath containerPath = LocalTargetHandle.LOCAL_TARGET_CONTAINER_PATH;
        ArrayList<ITargetHandle> handles = new ArrayList<ITargetHandle>(10);
        File directory = containerPath.toFile();
        if (directory.isDirectory()) {
            File[] files;
            FilenameFilter filter = (dir, name) -> dir.equals(directory) && name.endsWith("target");
            File[] fileArray = files = directory.listFiles(filter);
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                try {
                    handles.add(LocalTargetHandle.restoreHandle(file.toURI()));
                }
                catch (CoreException e) {
                    PDECore.log(e);
                }
                ++n2;
            }
        }
        return handles;
    }

    private List<WorkspaceFileTargetHandle> findWorkspaceTargetDefinitions() {
        ArrayList files = new ArrayList(10);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept(proxy -> {
                if (proxy.getType() == 1) {
                    if ("target".equalsIgnoreCase(IPath.fromOSString((String)proxy.getName()).getFileExtension())) {
                        files.add((IFile)proxy.requestResource());
                    }
                    return false;
                }
                return true;
            }, 0);
        }
        catch (CoreException e) {
            PDECore.log(e);
            return List.of();
        }
        return files.stream().map(WorkspaceFileTargetHandle::new).toList();
    }

    @Override
    public ITargetLocation newDirectoryLocation(String path) {
        return new DirectoryBundleContainer(path);
    }

    @Override
    public ITargetLocation newProfileLocation(String home, String configurationLocation) {
        return new ProfileBundleContainer(home, configurationLocation);
    }

    @Override
    public ITargetDefinition newTarget() {
        return new TargetDefinition(new LocalTargetHandle());
    }

    @Override
    public void saveTargetDefinition(ITargetDefinition definition) throws CoreException {
        ((AbstractTargetHandle)definition.getHandle()).save(definition);
    }

    @Override
    public ITargetLocation newFeatureLocation(String home, String id, String version) {
        return new FeatureBundleContainer(home, id, version);
    }

    @Override
    public ITargetHandle getWorkspaceTargetHandle() throws CoreException {
        PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
        String memento = preferences.getString("workspace_target_handle");
        if (memento != null && memento.length() != 0 && !memento.equals("NO_TARGET")) {
            return this.getTarget(memento);
        }
        return null;
    }

    @Override
    public synchronized ITargetDefinition getWorkspaceTargetDefinition() throws CoreException {
        ITargetDefinition workspaceTarget = this.fWorkspaceTarget.get();
        if (workspaceTarget != null && workspaceTarget.getHandle().equals(this.getWorkspaceTargetHandle())) {
            return workspaceTarget;
        }
        this.initDefaultTargetPlatformDefinition();
        String memento = PDECore.getDefault().getPreferencesManager().getString("workspace_target_handle");
        ITargetDefinition target = null;
        if (memento == null || memento.equals("") || memento.equals("NO_TARGET")) {
            target = this.newTarget();
        } else {
            ITargetHandle handle = this.getTarget(memento);
            target = handle.getTargetDefinition();
        }
        this.setWorkspaceTargetDefinition(target, true);
        return target;
    }

    public void setWorkspaceTargetDefinition(ITargetDefinition target, boolean asyncEvents) {
        ITargetDefinition oldTarget = this.fWorkspaceTarget.getAndSet(target);
        if (!Objects.equals(oldTarget, target)) {
            TargetPlatformService.notifyEvent("org/eclipse/pde/core/target/TargetEvents/workspaceTargetChanged", target, asyncEvents);
        }
    }

    public static void scheduleEvent(String topic, Object data) {
        TargetPlatformService.notifyEvent(topic, data, true);
    }

    private static void notifyEvent(String topic, Object data, boolean asyncEvents) {
        IEclipseContext context = EclipseContextFactory.getServiceContext((BundleContext)PDECore.getDefault().getBundleContext());
        IEventBroker broker = (IEventBroker)context.get(IEventBroker.class);
        if (broker != null) {
            if (asyncEvents) {
                broker.post(topic, data);
            } else {
                broker.send(topic, data);
            }
        }
    }

    private void initDefaultTargetPlatformDefinition() {
        String memento;
        PDEPreferencesManager preferenceManager = PDECore.getDefault().getPreferencesManager();
        if (this.removeInvalidTargetMementoInPreference(preferenceManager, memento = preferenceManager.getString("workspace_target_handle"))) {
            memento = preferenceManager.getString("workspace_target_handle");
        }
        if (memento == null || memento.equals("")) {
            try {
                if (PDECore.DEBUG_MODEL) {
                    System.out.println("No target platform memento, add default target.");
                }
                ITargetDefinition defaultTarget = this.newDefaultTarget();
                defaultTarget.setName(Messages.TargetPlatformService_7);
                this.saveTargetDefinition(defaultTarget);
                PDEPreferencesManager preferences = PDECore.getDefault().getPreferencesManager();
                ITargetHandle active = defaultTarget.getHandle();
                preferences.setValue("workspace_target_handle", active.getMemento());
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
        }
    }

    private boolean removeInvalidTargetMementoInPreference(PDEPreferencesManager preferenceManager, String memento) {
        if (memento != null && !memento.equals("") && !memento.equals("NO_TARGET")) {
            try {
                ITargetHandle handle = this.getTarget(memento);
                if (!handle.exists()) {
                    preferenceManager.setValueOrRemove("workspace_target_handle", preferenceManager.getDefaultString("workspace_target_handle"));
                    preferenceManager.flush();
                    return true;
                }
            }
            catch (CoreException | BackingStoreException e) {
                PDECore.log(e);
            }
        }
        return false;
    }

    @Override
    public void copyTargetDefinition(ITargetDefinition from, ITargetDefinition to) throws CoreException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ((TargetDefinition)from).write(outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ((TargetDefinition)to).setContents(inputStream);
    }

    @Override
    public void loadTargetDefinition(ITargetDefinition definition, String targetExtensionId) throws CoreException {
        IConfigurationElement elem = PDECore.getDefault().getTargetProfileManager().getTarget(targetExtensionId);
        if (elem == null) {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetPlatformService_2, (Object)targetExtensionId)));
        }
        String path = elem.getAttribute("definition");
        String symbolicName = elem.getDeclaringExtension().getContributor().getName();
        URL url = TargetDefinitionManager.getResourceURL(symbolicName, path);
        if (url != null) {
            try {
                ((TargetDefinition)definition).setContents(new BufferedInputStream(url.openStream()));
            }
            catch (IOException e) {
                throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetPlatformService_3, (Object)path), (Throwable)e));
            }
        } else {
            throw new CoreException(Status.error((String)NLS.bind((String)Messages.TargetPlatformService_4, (Object)path)));
        }
    }

    @Override
    public ITargetDefinition newDefaultTarget() {
        IPath configPath;
        IPath installPath;
        URL url;
        Location location;
        final ITargetDefinition target = this.newTarget();
        Location configArea = Platform.getConfigurationLocation();
        String configLocation = null;
        if (configArea != null) {
            configLocation = configArea.getURL().getFile();
        }
        if (configLocation != null && (location = Platform.getInstallLocation()) != null && (url = location.getURL()) != null && (installPath = IPath.fromOSString((String)url.getFile())).isPrefixOf(configPath = IPath.fromOSString((String)configLocation))) {
            configPath = configPath.removeFirstSegments(installPath.segmentCount());
            if ((configPath = configPath.setDevice(null)).segmentCount() == 1 && configPath.lastSegment().equals("configuration")) {
                configLocation = null;
            }
        }
        ITargetLocation container = this.newProfileLocation("${eclipse_home}", configLocation);
        target.setTargetLocations(new ITargetLocation[]{container});
        target.setName(Messages.TargetPlatformService_7);
        target.setArch(Platform.getOSArch());
        target.setOS(Platform.getOS());
        target.setWS(Platform.getWS());
        target.setNL(Platform.getNL());
        final ITargetLocation[] containers = target.getTargetLocations();
        Job job = new Job(Messages.TargetPlatformService_6){

            public IStatus run(IProgressMonitor monitor) {
                TargetPlatformService.this.fVMArguments = TargetPlatformService.this.getVMArguments(containers);
                return Status.OK_STATUS;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (TargetPlatformService.this.fVMArguments != null) {
                    target.setVMArguments(TargetPlatformService.this.fVMArguments.toString().trim());
                }
            }
        });
        job.schedule();
        return target;
    }

    private StringBuilder getVMArguments(ITargetLocation[] containers) {
        StringBuilder arguments = new StringBuilder("");
        if (containers != null) {
            ITargetLocation[] iTargetLocationArray = containers;
            int n = containers.length;
            int n2 = 0;
            while (n2 < n) {
                ITargetLocation container = iTargetLocationArray[n2];
                String[] vmargs = container.getVMArguments();
                if (vmargs != null) {
                    String[] stringArray = vmargs;
                    int n3 = vmargs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String vmarg = stringArray[n4];
                        arguments.append(vmarg).append(' ');
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return arguments;
    }

    @Override
    public IStatus compareWithTargetPlatform(ITargetDefinition target) throws CoreException {
        if (!target.isResolved()) {
            return null;
        }
        IPluginModelBase[] models = PDECore.getDefault().getModelManager().getExternalModels();
        HashSet<File> allFilesAtLocations = new HashSet<File>(models.length);
        LinkedHashMap<File, IPluginModelBase> stateLocations = new LinkedHashMap<File, IPluginModelBase>(models.length);
        IPluginModelBase[] iPluginModelBaseArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase base = iPluginModelBaseArray[n2];
            allFilesAtLocations.add(new File(base.getInstallLocation()));
            stateLocations.put(new File(base.getInstallLocation()), base);
            ++n2;
        }
        MultiStatus multi = new MultiStatus("org.eclipse.pde.core", 0, "", null);
        TargetBundle[] bundles = target.getAllBundles();
        HashSet<NameVersionDescriptor> alreadyConsidered = new HashSet<NameVersionDescriptor>(bundles.length);
        TargetBundle[] targetBundleArray = bundles;
        int n3 = bundles.length;
        int n4 = 0;
        while (n4 < n3) {
            TargetBundle bundle = targetBundleArray[n4];
            BundleInfo info = bundle.getBundleInfo();
            File file = URIUtil.toFile((URI)info.getLocation());
            String location = file.getAbsolutePath();
            File fileAtLocation = new File(location);
            stateLocations.remove(fileAtLocation);
            NameVersionDescriptor desc = new NameVersionDescriptor(info.getSymbolicName(), info.getVersion());
            if (!alreadyConsidered.contains(desc)) {
                IStatus status;
                alreadyConsidered.add(desc);
                if (!allFilesAtLocations.contains(fileAtLocation) && ((status = bundle.getStatus()).isOK() || status.getCode() != 100 && status.getCode() != 110 && status.getCode() != 101)) {
                    Status s = new Status(2, "org.eclipse.pde.core", 1, bundle.getBundleInfo().getSymbolicName(), null);
                    multi.add((IStatus)s);
                }
            }
            ++n4;
        }
        for (IPluginModelBase model : stateLocations.values()) {
            Status status = new Status(2, "org.eclipse.pde.core", 2, model.getPluginBase().getId(), null);
            multi.add((IStatus)status);
        }
        if (multi.isOK()) {
            return Status.OK_STATUS;
        }
        return multi;
    }

    @Override
    public ITargetLocation newIULocation(IInstallableUnit[] units, URI[] repositories, int resolutionFlags) {
        Stream<IUBundleContainer.UnitDeclaration> ius = Arrays.stream(units).map(iu -> IUBundleContainer.UnitDeclaration.create(iu.getId(), iu.getVersion()));
        return this.createIUBundleContainer(ius, repositories, resolutionFlags);
    }

    @Override
    public ITargetLocation newIULocation(String[] unitIds, String[] versions, URI[] repositories, int resolutionFlags) {
        if (unitIds.length != versions.length) {
            throw new IllegalArgumentException("Units and versions must have the same length");
        }
        Stream<IUBundleContainer.UnitDeclaration> ius = IntStream.range(0, unitIds.length).mapToObj(i -> IUBundleContainer.UnitDeclaration.parse(unitIds[i], versions[i]));
        return this.createIUBundleContainer(ius, repositories, resolutionFlags);
    }

    private ITargetLocation createIUBundleContainer(Stream<IUBundleContainer.UnitDeclaration> ius, URI[] repos, int resolutionFlags) {
        return new IUBundleContainer(ius.toList(), repos == null ? List.of() : List.of(repos), resolutionFlags);
    }
}

