/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.context.XMLDocumentSetupParticpant;
import org.eclipse.pde.internal.ui.editor.text.ChangeAwareSourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.XMLConfiguration;
import org.eclipse.pde.internal.ui.preferences.SyntaxColorTab;

public class XMLSyntaxColorTab
extends SyntaxColorTab {
    private static final String[][] COLOR_STRINGS = new String[][]{{PDEUIMessages.EditorPreferencePage_text, "editor.color.default"}, {PDEUIMessages.EditorPreferencePage_proc, "editor.color.instr"}, {PDEUIMessages.EditorPreferencePage_tag, "editor.color.tag"}, {PDEUIMessages.EditorPreferencePage_string, "editor.color.string"}, {PDEUIMessages.XMLSyntaxColorTab_externalizedStrings, "editor.color.externalized_string"}, {PDEUIMessages.EditorPreferencePage_comment, "editor.color.xml_comment"}};

    public XMLSyntaxColorTab(IColorManager manager) {
        super(manager);
    }

    @Override
    protected IDocument getDocument() {
        StringBuilder buffer = new StringBuilder();
        String delimiter = System.lineSeparator();
        buffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        buffer.append(delimiter);
        buffer.append("<plugin>");
        buffer.append(delimiter);
        buffer.append("<!-- Comment -->");
        buffer.append(delimiter);
        buffer.append("   <extension point=\"some.id\">");
        buffer.append(delimiter);
        buffer.append("      <tag name=\"%externalized\">body text</tag>");
        buffer.append(delimiter);
        buffer.append("   </extension>");
        buffer.append(delimiter);
        buffer.append("</plugin>");
        Document document = new Document(buffer.toString());
        new XMLDocumentSetupParticpant().setup((IDocument)document);
        return document;
    }

    @Override
    protected ChangeAwareSourceViewerConfiguration getSourceViewerConfiguration() {
        return new XMLConfiguration(this.fColorManager);
    }

    @Override
    protected String[][] getColorStrings() {
        return COLOR_STRINGS;
    }
}

