/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.internal.interpreter;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IConverter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterProvider;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterStatus;
import org.eclipse.sirius.common.tools.api.interpreter.TypedValidation;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.internal.interpreter.DefaultConverter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.MetamodelDescriptor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;

public class DefaultInterpreterProvider
implements IInterpreterProvider,
IInterpreter,
TypedValidation {
    @Override
    public IInterpreter createInterpreter() {
        return this;
    }

    @Override
    public IConverter getConverter() {
        return new DefaultConverter();
    }

    @Override
    public void dispose() {
    }

    @Override
    public boolean provides(String expression) {
        return true;
    }

    @Override
    public void activateMetamodels(Collection<MetamodelDescriptor> metamodels) {
    }

    @Override
    public void addImport(String dependency) {
    }

    @Override
    public void clearImports() {
    }

    @Override
    public void clearVariables() {
    }

    @Override
    public Object evaluate(EObject target, String expression) throws EvaluationException {
        Integer result = this.evaluateInteger(target, expression);
        if (result != null) {
            return result;
        }
        return expression;
    }

    @Override
    public boolean evaluateBoolean(EObject context, String expression) throws EvaluationException {
        return Boolean.parseBoolean(expression);
    }

    @Override
    public Collection<EObject> evaluateCollection(EObject context, String expression) throws EvaluationException {
        return Collections.emptyList();
    }

    @Override
    public EObject evaluateEObject(EObject context, String expression) throws EvaluationException {
        return context;
    }

    @Override
    public Integer evaluateInteger(EObject context, String expression) throws EvaluationException {
        try {
            return new Integer(expression);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    @Override
    public String evaluateString(EObject context, String expression) throws EvaluationException {
        return expression;
    }

    @Override
    public Object getVariable(String name) {
        return null;
    }

    public Map<String, Object> getVariables() {
        return Collections.emptyMap();
    }

    @Override
    public void setModelAccessor(ModelAccessor modelAccessor) {
    }

    @Override
    public void setProperty(Object key, Object value) {
    }

    @Override
    public void setVariable(String name, Object value) {
    }

    @Override
    public void unSetVariable(String name) {
    }

    @Override
    public String getPrefix() {
        return null;
    }

    @Override
    public String getVariablePrefix() {
        return null;
    }

    @Override
    public void setCrossReferencer(ECrossReferenceAdapter crossReferencer) {
    }

    @Override
    public Collection<String> getImports() {
        return Collections.emptyList();
    }

    @Override
    public void removeImport(String dependency) {
    }

    @Override
    public Collection<IInterpreterStatus> validateExpression(IInterpreterContext context, String expression) {
        return Sets.newLinkedHashSet();
    }

    @Override
    public boolean supportsValidation() {
        return false;
    }

    @Override
    public ValidationResult analyzeExpression(IInterpreterContext context, String expression) {
        return new ValidationResult();
    }
}

