/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.model.business.internal.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.description.AdditionalLayer;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.model.business.internal.description.spec.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.model.business.internal.helper.ContentLayerHelper;
import org.eclipse.sirius.viewpoint.description.DecorationDescription;

public final class LayerModelHelper {
    private LayerModelHelper() {
    }

    public static EList<Layer> getAllLayers(DiagramDescription description) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        if (description.getDefaultLayer() != null) {
            layers.add(description.getDefaultLayer());
        }
        layers.addAll((Collection<Layer>)description.getAdditionalLayers());
        return new BasicEList(layers);
    }

    public static Layer getContainingLayer(DiagramElementMapping mapping) {
        DiagramElementMapping current = mapping;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Layer)) continue;
            return (Layer)((Object)current);
        }
        return null;
    }

    public static Layer getParentLayer(DecorationDescription decorationDescription) {
        DecorationDescription current = decorationDescription;
        while (current != null) {
            if (!((current = current.eContainer()) instanceof Layer)) continue;
            return (Layer)current;
        }
        return null;
    }

    public static boolean isInActivatedLayer(DDiagram diagram, IEdgeMapping mapping) {
        boolean found = false;
        if (!found && (diagram.getDescription().getEdgeMappings().contains((Object)mapping) || diagram.getDescription().getEdgeMappingImports().contains((Object)mapping) || LayerModelHelper.containsWrapped(diagram.getDescription().getEdgeMappingImports(), mapping))) {
            found = true;
        }
        for (Layer layer : diagram.getActivatedLayers()) {
            if (!layer.getEdgeMappings().contains((Object)mapping) && !layer.getEdgeMappingImports().contains((Object)mapping) && !LayerModelHelper.containsWrapped(layer.getEdgeMappingImports(), mapping)) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean containsWrapped(EList<EdgeMappingImport> edgeMappingImports, IEdgeMapping mapping) {
        for (EdgeMappingImport edgeMappingImport : edgeMappingImports) {
            if (!mapping.equals(EdgeMappingImportWrapper.getWrapper(edgeMappingImport))) continue;
            return true;
        }
        return false;
    }

    public static boolean withoutLayersMode(DiagramElementMapping mapping) {
        return LayerModelHelper.getContainingLayer(mapping) == null;
    }

    public static EdgeMapping getBestMapping(EdgeMapping edgeMapping, DDiagram diagram) {
        BasicEList edgeMappingImportWrappers = new BasicEList();
        for (EdgeMappingImport edgeMappingImport : diagram.getDescription().getEdgeMappingImports()) {
            edgeMappingImportWrappers.add((Object)EdgeMappingImportWrapper.getWrapper(edgeMappingImport));
        }
        for (Layer layer : diagram.getActivatedLayers()) {
            for (EdgeMapping otherEdgeMapping : ContentLayerHelper.getAllEdgeMappings(layer)) {
                if (!(otherEdgeMapping instanceof EdgeMappingImportWrapper)) continue;
                edgeMappingImportWrappers.add((Object)((EdgeMappingImportWrapper)otherEdgeMapping));
            }
        }
        EdgeMapping result = edgeMapping instanceof EdgeMappingImportWrapper && !edgeMappingImportWrappers.contains((Object)edgeMapping) ? null : LayerModelHelper.getBestMapping(edgeMapping, (EList<EdgeMappingImportWrapper>)edgeMappingImportWrappers);
        return result;
    }

    public static EdgeMapping getBestMapping(EdgeMapping edgeMapping, EList<EdgeMappingImportWrapper> edgeMappingImportWrappers) {
        EdgeMapping result = edgeMapping;
        for (EdgeMappingImportWrapper edgeMappingImportWrapper : edgeMappingImportWrappers) {
            if (!LayerModelHelper.isImported(edgeMapping, edgeMappingImportWrapper.getWrappedEdgeMappingImport())) continue;
            result = LayerModelHelper.getBestMapping((EdgeMapping)edgeMappingImportWrapper, edgeMappingImportWrappers);
            break;
        }
        return result;
    }

    public static boolean isImported(IEdgeMapping searchImportedMapping, EdgeMappingImport edgeMappingImport) {
        boolean result = false;
        IEdgeMapping importedMapping = edgeMappingImport.getImportedMapping();
        IEdgeMapping mappingToCompare = searchImportedMapping;
        if (searchImportedMapping instanceof EdgeMappingImportWrapper) {
            mappingToCompare = ((EdgeMappingImportWrapper)searchImportedMapping).getWrappedEdgeMappingImport();
        }
        result = importedMapping == null ? false : (importedMapping.equals(mappingToCompare) ? true : (importedMapping instanceof EdgeMappingImport ? LayerModelHelper.isImported(searchImportedMapping, (EdgeMappingImport)importedMapping) : importedMapping.equals(searchImportedMapping)));
        return result;
    }

    public static boolean containsOnlyTools(Layer layer) {
        boolean isNoDecorationDescritionSet;
        boolean containsMappings = LayerModelHelper.containsMappings(layer);
        boolean bl = isNoDecorationDescritionSet = layer.getDecorationDescriptionsSet() == null || layer.getDecorationDescriptionsSet().getDecorationDescriptions().isEmpty();
        return !containsMappings && isNoDecorationDescritionSet;
    }

    private static boolean containsMappings(Layer layer) {
        boolean isNoMapping = layer.getContainerMappings().isEmpty() && layer.getEdgeMappings().isEmpty() && layer.getNodeMappings().isEmpty();
        boolean isNoImportOrReusedMapping = layer.getEdgeMappingImports().isEmpty() && layer.getReusedMappings().isEmpty();
        return !isNoMapping || !isNoImportOrReusedMapping;
    }

    public static boolean isTransientLayer(Layer layer) {
        if (layer instanceof AdditionalLayer) {
            boolean containsCusto;
            boolean containsMappings = LayerModelHelper.containsMappings(layer);
            boolean bl = containsCusto = layer.getCustomization() != null && !layer.getCustomization().getVsmElementCustomizations().isEmpty();
            return !containsMappings && !containsCusto;
        }
        return false;
    }

    public static Collection<DiagramElementMapping> getAllLayerMappings(Layer layer) {
        HashSet<DiagramElementMapping> result = new HashSet<DiagramElementMapping>();
        result.addAll((Collection<DiagramElementMapping>)layer.getNodeMappings());
        result.addAll((Collection<DiagramElementMapping>)layer.getContainerMappings());
        result.addAll((Collection<DiagramElementMapping>)layer.getEdgeMappings());
        Iterator iterMappingImport = layer.getEdgeMappingImports().iterator();
        while (iterMappingImport.hasNext()) {
            result.add(EdgeMappingImportWrapper.getWrapper((EdgeMappingImport)iterMappingImport.next()));
        }
        result.addAll(ContentLayerHelper.getReuseMappings(layer));
        return result;
    }

    public static boolean withoutLayersMode(DiagramDescription diagramDescription) {
        return diagramDescription.getDefaultLayer() == null;
    }
}

