/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.business.internal.migration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.helper.RepresentationHelper;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.description.style.NodeStyleDescription;
import org.eclipse.sirius.diagram.ui.business.api.query.EdgeQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeQuery;
import org.eclipse.sirius.diagram.ui.tools.internal.util.GMFNotationUtilities;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;
import org.osgi.framework.Version;

public class DiagramRepresentationsFileMigrationParticipantV650 {
    public static final Version MIGRATION_VERSION = new Version("6.5.0.201209041254");
    private Predicate<EObject> nonResizableNodeWithDifferentSizePredicate = new Predicate<EObject>(){

        @Override
        public boolean test(EObject input) {
            DNode dNode;
            StyleDescription styleDescription;
            Node node;
            boolean apply = false;
            if (input instanceof Node && (node = (Node)input).getElement() instanceof DNode && (styleDescription = (dNode = (DNode)node.getElement()).getStyle().getDescription()) instanceof NodeStyleDescription) {
                NodeStyleDescription nodeStyleDescription = (NodeStyleDescription)styleDescription;
                apply = nodeStyleDescription.getResizeKind() == ResizeKind.NONE_LITERAL && this.hasDifferentSizeOfGMFNodeSize(dNode, node);
            }
            return apply;
        }

        private boolean hasDifferentSizeOfGMFNodeSize(DNode dNode, Node node) {
            boolean hasDifferentSizeOfGMFNodeSize = false;
            LayoutConstraint layoutConstraint = node.getLayoutConstraint();
            if (layoutConstraint instanceof Size) {
                Size size = (Size)layoutConstraint;
                hasDifferentSizeOfGMFNodeSize = size.getWidth() != dNode.getWidth().intValue() || size.getHeight() != dNode.getHeight().intValue();
            }
            return hasDifferentSizeOfGMFNodeSize;
        }
    };
    private Predicate<EObject> edgeWithTreeRoutingPredicate = new Predicate<EObject>(){

        @Override
        public boolean test(EObject input) {
            boolean apply = false;
            if (input instanceof Edge) {
                apply = new EdgeQuery((Edge)input).isEdgeWithTreeRoutingStyle();
            }
            return apply;
        }
    };

    public static List<Diagram> getDiagramsAtRoot(DAnalysis dAnalysis) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        for (EObject object : dAnalysis.eResource().getContents()) {
            if (!(object instanceof Diagram)) continue;
            diagrams.add((Diagram)object);
        }
        return diagrams;
    }

    public void moveGMFDiagramsFromRoot(DAnalysis dAnalysis, List<Diagram> diagrams) {
        for (Diagram diagram : diagrams) {
            if (diagram == null) continue;
            if (diagram.getElement() instanceof DRepresentation) {
                RepresentationHelper.getOrCreateAnnotation((String)"GMF_DIAGRAMS", (DRepresentation)((DRepresentation)diagram.getElement()), (EObject)diagram);
                continue;
            }
            if (diagram.getElement() != null && !diagram.getElement().eIsProxy()) continue;
            EcoreUtil.remove((EObject)diagram);
        }
        for (DView view : dAnalysis.getOwnedViews()) {
            this.migrationForGMFViewSizeForDNodeNotResizable(view);
            this.fixAnchorsOfGMFTreeEdge(view);
        }
    }

    private void migrationForGMFViewSizeForDNodeNotResizable(DView view) {
        Iterator viewIterator = new DViewQuery(view).getAllContentInRepresentations(this.nonResizableNodeWithDifferentSizePredicate);
        while (viewIterator.hasNext()) {
            EObject next = (EObject)viewIterator.next();
            if (!(next instanceof Node)) continue;
            Node node = (Node)next;
            DNode dNode = (DNode)node.getElement();
            Size size = (Size)node.getLayoutConstraint();
            Dimension dNodeSize = new DNodeQuery(dNode).getDefaultDimension();
            size.setWidth(dNodeSize.width);
            size.setHeight(dNodeSize.height);
        }
    }

    private void fixAnchorsOfGMFTreeEdge(DView view) {
        HashMap<View, List<Edge>> edgesSortPerSource = new HashMap<View, List<Edge>>();
        HashMap<View, List<Edge>> edgesSortPerTarget = new HashMap<View, List<Edge>>();
        Iterator viewIterator = new DViewQuery(view).getAllContentInRepresentations(this.edgeWithTreeRoutingPredicate);
        while (viewIterator.hasNext()) {
            EObject next = (EObject)viewIterator.next();
            if (!(next instanceof Edge)) continue;
            Edge edge = (Edge)next;
            ArrayList<Edge> edgesWithSameSource = (ArrayList<Edge>)edgesSortPerSource.get(edge.getSource());
            if (edgesWithSameSource == null) {
                edgesWithSameSource = new ArrayList<Edge>();
            }
            edgesWithSameSource.add(edge);
            edgesSortPerSource.put(edge.getSource(), edgesWithSameSource);
            ArrayList<Edge> edgesWithSameTarget = (ArrayList<Edge>)edgesSortPerTarget.get(edge.getTarget());
            if (edgesWithSameTarget == null) {
                edgesWithSameTarget = new ArrayList<Edge>();
            }
            edgesWithSameTarget.add(edge);
            edgesSortPerTarget.put(edge.getTarget(), edgesWithSameTarget);
        }
        this.setSameAnchor(edgesSortPerSource, true);
        this.setSameAnchor(edgesSortPerTarget, false);
    }

    protected void setSameAnchor(Map<View, List<Edge>> edgesSortPerCommonAnchor, boolean sourceAnchor) {
        for (Map.Entry<View, List<Edge>> entry : edgesSortPerCommonAnchor.entrySet()) {
            Option<String> replacementId;
            List<Edge> edgesForAnchor = entry.getValue();
            if (edgesForAnchor.size() <= 1 || !(replacementId = this.getReplacementId(edgesForAnchor, sourceAnchor)).some()) continue;
            for (Edge edge : edgesForAnchor) {
                Anchor anchor = this.getAnchor(edge, sourceAnchor);
                if (anchor instanceof IdentityAnchor) {
                    ((IdentityAnchor)anchor).setId((String)replacementId.get());
                    continue;
                }
                IdentityAnchor identityAnchor = NotationFactory.eINSTANCE.createIdentityAnchor();
                identityAnchor.setId((String)replacementId.get());
                edge.setTargetAnchor((Anchor)identityAnchor);
            }
        }
    }

    private Option<String> getReplacementId(List<Edge> edges, boolean sourceAnchor) {
        String id = null;
        boolean sameId = true;
        boolean onlyOneIdInTheTree = false;
        boolean atLeastOneNullAnchor = false;
        for (Edge edge : edges) {
            Anchor anchor = this.getAnchor(edge, sourceAnchor);
            if (anchor instanceof IdentityAnchor) {
                if (id == null) {
                    id = ((IdentityAnchor)anchor).getId();
                    onlyOneIdInTheTree = true;
                    if (!atLeastOneNullAnchor) continue;
                    sameId = false;
                    continue;
                }
                onlyOneIdInTheTree = false;
                if (id.equals(((IdentityAnchor)anchor).getId())) continue;
                sameId = false;
                continue;
            }
            atLeastOneNullAnchor = true;
            if (id == null) continue;
            sameId = false;
        }
        if (!sameId) {
            String defaultTerminalString = GMFNotationUtilities.getTerminalString(0.5, 0.5);
            if (onlyOneIdInTheTree) {
                defaultTerminalString = id;
            }
            return Options.newSome((Object)defaultTerminalString);
        }
        return Options.newNone();
    }

    protected Anchor getAnchor(Edge edge, boolean sourceAnchor) {
        if (sourceAnchor) {
            return edge.getSourceAnchor();
        }
        return edge.getTargetAnchor();
    }
}

