/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.layout;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.internal.graph.VirtualNode;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.model.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.model.business.internal.query.DNodeContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.EditPartQuery;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramElementContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramListEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DDiagramEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.SquareEditPart;
import org.eclipse.sirius.diagram.ui.internal.operation.RegionContainerUpdateLayoutOperation;
import org.eclipse.sirius.diagram.ui.internal.view.factories.AbstractContainerViewFactory;
import org.eclipse.sirius.diagram.ui.provider.DiagramUIPlugin;
import org.eclipse.sirius.diagram.ui.tools.internal.edit.command.CommandFactory;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.LayoutUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.layout.provider.AbstractCompositeLayoutProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.preferences.SiriusDiagramUiInternalPreferencesKeys;

public class ArrangeAllWithAutoSize {
    public static boolean shouldBeAutosized(IGraphicalEditPart part) {
        EditPart regionContainerCompartment;
        boolean enabled = ArrangeAllWithAutoSize.isEnabled() && (ArrangeAllWithAutoSize.isContainer(part) || ArrangeAllWithAutoSize.isList(part)) && !new EditPartQuery(part).isPinned();
        boolean bl = enabled = enabled && !ArrangeAllWithAutoSize.isDefaultSizeHasJustBeenSet(part);
        if (enabled && ArrangeAllWithAutoSize.isRegion(part) && (regionContainerCompartment = part.getParent()) != null) {
            EditPart regionContainer = regionContainerCompartment.getParent();
            enabled = regionContainer instanceof IGraphicalEditPart && !new EditPartQuery((IGraphicalEditPart)regionContainer).isPinned();
        }
        return enabled;
    }

    private static boolean isDefaultSizeHasJustBeenSet(IGraphicalEditPart part) {
        View view = part.getNotationView();
        if (view != null) {
            Iterator iterator = view.eAdapters().iterator();
            while (iterator.hasNext()) {
                Adapter adapter = (Adapter)iterator.next();
                if (!adapter.isAdapterForType(AbstractContainerViewFactory.class)) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    private static boolean isContainer(IGraphicalEditPart part) {
        return part instanceof IDiagramContainerEditPart;
    }

    private static boolean isList(IGraphicalEditPart part) {
        return part instanceof IDiagramListEditPart;
    }

    public static boolean isEnabled() {
        return DiagramUIPlugin.getPlugin().getPreferenceStore().getBoolean(SiriusDiagramUiInternalPreferencesKeys.PREF_AUTOSIZE_ON_ARRANGE.name());
    }

    public void prepareForArrangeAll(Iterator<AbstractDiagramElementContainerEditPart> unmodifiableIterator) {
        this.prepareForArrangeAll(unmodifiableIterator, null);
    }

    public void prepareForArrangeAll(Iterator<AbstractDiagramElementContainerEditPart> unmodifiableIterator, ArrayList<IDiagramElementEditPart> elementsToKeepFixed) {
        LinkedHashSet<IFigure> parentFiguresToValidateToGetAutosizeDimensions = new LinkedHashSet<IFigure>();
        while (unmodifiableIterator.hasNext()) {
            AbstractDiagramElementContainerEditPart ep = unmodifiableIterator.next();
            if (elementsToKeepFixed != null && elementsToKeepFixed.contains(ep) || !ArrangeAllWithAutoSize.shouldBeAutosized(ep)) continue;
            ep.forceFigureAutosize();
            if (!(ep.getParent() instanceof AbstractGraphicalEditPart)) continue;
            parentFiguresToValidateToGetAutosizeDimensions.add(((AbstractGraphicalEditPart)ep.getParent()).getFigure());
        }
        for (IFigure parentFig : parentFiguresToValidateToGetAutosizeDimensions) {
            parentFig.validate();
        }
    }

    public Dimension getSizeToConsiderDuringArrangeAll(IGraphicalEditPart ep) {
        Dimension size = ArrangeAllWithAutoSize.shouldBeAutosized(ep) && ep instanceof AbstractDiagramElementContainerEditPart ? ((AbstractDiagramElementContainerEditPart)ep).getAutosizedDimensions().getSize() : ep.getFigure().getBounds().getSize();
        return size;
    }

    public void createSubCommands(Point globalDiff, ListIterator vi, CompoundCommand cc, AbstractCompositeLayoutProvider provider, int minX, int minY) {
        ArrayList nodes = Lists.newArrayList((Iterator)vi);
        vi = nodes.listIterator();
        Point ptLayoutMin = this.computePointLayoutMin(nodes, provider);
        while (vi.hasNext()) {
            Node node = (Node)vi.next();
            if (!(node.data instanceof ShapeEditPart)) continue;
            this.createSubCommands(globalDiff, cc, provider, minX, minY, ptLayoutMin, node);
        }
    }

    private void createSubCommands(Point globalDiff, CompoundCommand cc, AbstractCompositeLayoutProvider provider, int minX, int minY, Point ptLayoutMin, Node node) {
        Point diffP = this.diff(minX, minY, ptLayoutMin, provider, node);
        diffP.setX(Math.max(diffP.x, globalDiff.x));
        diffP.setY(Math.max(diffP.y, globalDiff.y));
        if (diffP.x > -node.getPadding().left) {
            diffP.setX(-node.getPadding().left);
        }
        if (diffP.y > -node.getPadding().bottom) {
            diffP.setY(-node.getPadding().bottom);
        }
        Rectangle nodeExt = provider.translateToGraph(provider.provideNodeMetrics(node));
        this.createSubCommands(cc, node, diffP, nodeExt);
    }

    private void createSubCommands(CompoundCommand cc, Node node, Point diff, Rectangle nodeExt) {
        if (node.getParent() instanceof VirtualNode) {
            if (nodeExt.x > node.getPadding().left) {
                nodeExt.setX(nodeExt.x - node.getPadding().left);
            }
            if (nodeExt.y > node.getPadding().top) {
                nodeExt.setY(nodeExt.y - node.getPadding().top);
            }
        }
        Point pt = new Point();
        if (nodeExt.x + diff.x > 0) {
            pt.setX(nodeExt.x + diff.x);
        } else {
            pt.setX(nodeExt.x);
        }
        if (nodeExt.y + diff.y > 0) {
            pt.setY(nodeExt.y + diff.y);
        } else {
            pt.setY(nodeExt.y);
        }
        Point ptLocation = new Point(pt.x, pt.y);
        IGraphicalEditPart gep = (IGraphicalEditPart)node.data;
        Point ptOldLocation = gep.getFigure().getBounds().getLocation();
        gep.getFigure().translateToAbsolute((Translatable)ptOldLocation);
        gep.getFigure().translateToAbsolute((Translatable)ptLocation);
        if (gep.getParent() instanceof DDiagramEditPart) {
            if (node.x == node.getPadding().left) {
                ptLocation.setX(ptLocation.x - node.getPadding().left);
            }
            if (node.y == node.getPadding().bottom) {
                ptLocation.setY(ptLocation.y - node.getPadding().bottom);
            }
        }
        Dimension delta = ptLocation.getDifference(ptOldLocation);
        ChangeBoundsRequest request = new ChangeBoundsRequest((Object)"move");
        boolean isRegion = ArrangeAllWithAutoSize.isRegion(gep);
        if (isRegion) {
            Dimension size = nodeExt.getSize().getCopy();
            Dimension oldSize = gep.getFigure().getBounds().getSize();
            gep.getFigure().translateToAbsolute((Translatable)oldSize);
            gep.getFigure().translateToAbsolute((Translatable)size);
            Dimension deltaSize = size.getShrinked(oldSize);
            request.setType((Object)"resize");
            request.setConstrainedResize(true);
            request.setSizeDelta(deltaSize);
        }
        if (LayoutUtil.isArrangeAtOpeningChangesDisabled()) {
            if (delta.height != 0 || delta.width != 0 || isRegion && (request.getSizeDelta().height != 0 || request.getSizeDelta().width != 0)) {
                request.setEditParts((EditPart)gep);
                request.setMoveDelta(new Point(delta.width, delta.height));
                request.setLocation(ptLocation);
                if (ArrangeAllWithAutoSize.shouldBeAutosized(gep)) {
                    cmd = new CompoundCommand();
                    cmd.add(gep.getCommand((Request)request));
                    cmd.add(gep.getCommand(new Request((Object)"autosize")));
                    cc.add((Command)cmd);
                } else {
                    cmd = gep.getCommand((Request)request);
                    if (cmd != null && cmd.canExecute()) {
                        cc.add((Command)cmd);
                    }
                }
            }
        } else {
            cmd = new CompoundCommand();
            if (delta.height != 0 || delta.width != 0 || isRegion && (request.getSizeDelta().height != 0 || request.getSizeDelta().width != 0)) {
                request.setEditParts((EditPart)gep);
                request.setMoveDelta(new Point(delta.width, delta.height));
                request.setLocation(ptLocation);
                cmd.add(gep.getCommand((Request)request));
            }
            if (ArrangeAllWithAutoSize.shouldBeAutosized(gep)) {
                cmd.add(gep.getCommand(new Request((Object)"autosize")));
            }
            if (cmd.canExecute()) {
                cc.add((Command)cmd);
            }
        }
        if (ArrangeAllWithAutoSize.isRegionContainer(gep)) {
            cc.add((Command)new ICommandProxy(CommandFactory.createICommand(gep.getEditingDomain(), new RegionContainerUpdateLayoutOperation((org.eclipse.gmf.runtime.notation.Node)gep.getModel()))));
        }
    }

    private static boolean isRegion(IGraphicalEditPart gep) {
        DDiagramElement resolveDiagramElement;
        if (gep instanceof AbstractDiagramElementContainerEditPart && (resolveDiagramElement = ((AbstractDiagramElementContainerEditPart)gep).resolveDiagramElement()) instanceof DDiagramElementContainer) {
            return new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)resolveDiagramElement).isRegion();
        }
        return false;
    }

    private static boolean isRegionContainer(IGraphicalEditPart gep) {
        DDiagramElement resolveDiagramElement;
        if (gep instanceof IDiagramContainerEditPart && (resolveDiagramElement = ((IDiagramContainerEditPart)gep).resolveDiagramElement()) instanceof DNodeContainer) {
            return new DNodeContainerExperimentalQuery((DNodeContainer)resolveDiagramElement).isRegionContainer();
        }
        return false;
    }

    private Point diff(int minX, int minY, Point ptLayoutMin, AbstractCompositeLayoutProvider provider, Node firstNode) {
        if (ptLayoutMin.x == firstNode.x) {
            return provider.translateFromGraph(new Rectangle(0, 0, 0, 0)).getLocation();
        }
        return provider.translateFromGraph(new Rectangle(minX - ptLayoutMin.x, minY - ptLayoutMin.y, 0, 0)).getLocation();
    }

    private Point computePointLayoutMin(List<Node> nodes, AbstractCompositeLayoutProvider provider) {
        Point ptLayoutMin = new Point(-1, -1);
        for (Node node : nodes) {
            if (node.data == null) continue;
            Rectangle nodeExt = provider.provideNodeMetrics(node);
            nodeExt = ArrangeAllWithAutoSize.extendBoundingBoxWithBorderedNodes(node, nodeExt);
            if (ptLayoutMin.x == -1) {
                ptLayoutMin.setX(nodeExt.x);
                ptLayoutMin.setY(nodeExt.y);
                continue;
            }
            ptLayoutMin.setX(Math.min(ptLayoutMin.x, nodeExt.x));
            ptLayoutMin.setY(Math.min(ptLayoutMin.y, nodeExt.y));
        }
        return ptLayoutMin;
    }

    static Rectangle extendBoundingBoxWithBorderedNodes(Node node, Rectangle box) {
        Rectangle extendedBox = box.getCopy();
        if (node.data instanceof IGraphicalEditPart) {
            Rectangle translate;
            IGraphicalEditPart gep = (IGraphicalEditPart)node.data;
            Dimension delta = box.getLocation().getDifference(gep.getFigure().getBounds().getLocation());
            for (AbstractDiagramBorderNodeEditPart borderedNode : Iterables.filter((Iterable)gep.getChildren(), AbstractDiagramBorderNodeEditPart.class)) {
                translate = borderedNode.getFigure().getBounds().getCopy().translate(delta.width, delta.height);
                extendedBox.union(translate);
            }
            Rectangle extendedBoxName = new Rectangle();
            for (AbstractDiagramNameEditPart nameNode : Iterables.filter((Iterable)gep.getChildren(), AbstractDiagramNameEditPart.class)) {
                Rectangle translate2 = nameNode.getFigure().getBounds().getCopy();
                extendedBoxName.union(new Dimension(0, translate2.height));
            }
            Iterator iterator = Iterables.filter((Iterable)gep.getChildren(), SquareEditPart.class).iterator();
            while (iterator.hasNext()) {
                SquareEditPart cfr_ignored_0 = (SquareEditPart)iterator.next();
                translate = gep.getFigure().getMinimumSize().getCopy();
                extendedBoxName.union(new Dimension(0, translate.height));
            }
            if (extendedBoxName.height > extendedBox.y) {
                extendedBox.translate(extendedBoxName.width, extendedBoxName.height);
            }
        }
        if (extendedBox.x < node.getPadding().left) {
            extendedBox.setX(node.getPadding().left);
        }
        if (extendedBox.y < node.getPadding().bottom) {
            extendedBox.setY(node.getPadding().bottom);
        }
        return extendedBox;
    }
}

