/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.routers;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.sirius.diagram.description.CenteringStyle;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionEditPartQuery;
import org.eclipse.sirius.diagram.ui.business.api.query.ConnectionQuery;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public final class RectilinearEdgeUtil {
    private static final int MINIMAL_SEGMENT_SIZE = 20;

    private RectilinearEdgeUtil() {
    }

    public static void centerEdgeEnds(PointList line, Point srcRefPoint, Point tgtRefPoint, CenteringStyle centeringStyle) {
        if (CenteringStyle.BOTH == centeringStyle || CenteringStyle.SOURCE == centeringStyle) {
            RectilinearEdgeUtil.addPointsIfNeeded(line, srcRefPoint, true);
            RectilinearEdgeUtil.alignSegmentTowardAnchor(line, srcRefPoint, true);
        }
        if (CenteringStyle.BOTH == centeringStyle || CenteringStyle.TARGET == centeringStyle) {
            RectilinearEdgeUtil.addPointsIfNeeded(line, tgtRefPoint, false);
            RectilinearEdgeUtil.alignSegmentTowardAnchor(line, tgtRefPoint, false);
        }
        RectilinearEdgeUtil.removeRedundantPoints(line);
    }

    private static void addPointsIfNeeded(PointList line, Point absoluteAnchorCoordinates, boolean isFirst) {
        if (line.size() == 2) {
            RectilinearEdgeUtil.addPointForStraightEdge(line);
        } else if (line.size() == 3 && RectilinearEdgeUtil.isOppositeEndWillBeAffected(line, absoluteAnchorCoordinates, isFirst)) {
            RectilinearEdgeUtil.addPointForLEdge(line, isFirst);
        }
    }

    private static void addPointForStraightEdge(PointList line) {
        int segmentOrientation;
        Point pointToInsert = null;
        int n = segmentOrientation = line.getFirstPoint().x == line.getLastPoint().x ? 128 : 64;
        if (segmentOrientation == 128) {
            int xValue = line.getFirstPoint().x;
            int delta = (line.getFirstPoint().y - line.getLastPoint().y) / 2;
            pointToInsert = new Point(xValue, line.getFirstPoint().y - delta);
        } else {
            int yValue = line.getFirstPoint().y;
            int delta = (line.getFirstPoint().x - line.getLastPoint().x) / 2;
            pointToInsert = new Point(line.getFirstPoint().x - delta, yValue);
        }
        line.insertPoint(pointToInsert, 1);
        line.insertPoint(pointToInsert.getCopy(), 1);
    }

    private static boolean isOppositeEndWillBeAffected(PointList line, Point absoluteAnchorCoordinates, boolean isFirst) {
        LineSeg oppositeSegment = RectilinearEdgeUtil.getSegment(line, !isFirst);
        int origTermDelta = 0;
        int origNewLocDelta = 0;
        if (oppositeSegment.isVertical()) {
            origTermDelta = oppositeSegment.getOrigin().y - oppositeSegment.getTerminus().y;
            origNewLocDelta = oppositeSegment.getOrigin().y - absoluteAnchorCoordinates.y;
        } else {
            origTermDelta = oppositeSegment.getOrigin().x - oppositeSegment.getTerminus().x;
            origNewLocDelta = oppositeSegment.getOrigin().x - absoluteAnchorCoordinates.x;
        }
        return origTermDelta > 0 ^ origNewLocDelta > 0;
    }

    private static void addPointForLEdge(PointList line, boolean isFirst) {
        LineSeg segment = RectilinearEdgeUtil.getSegment(line, isFirst);
        Point origin = segment.getOrigin();
        Point terminus = segment.getTerminus();
        Point newPoint = origin.getCopy();
        if (segment.isHorizontal()) {
            int newPointX = origin.x > terminus.x ? origin.x - 20 : origin.x + 20;
            newPoint.setX(newPointX);
        } else {
            int newPointY = origin.y > terminus.y ? origin.y - 20 : origin.y + 20;
            newPoint.setY(newPointY);
        }
        if (isFirst) {
            line.insertPoint(newPoint, 1);
            line.insertPoint(newPoint.getCopy(), 1);
        } else {
            line.insertPoint(newPoint, line.size() - 1);
            line.insertPoint(newPoint.getCopy(), line.size() - 1);
        }
    }

    private static void alignSegmentTowardAnchor(PointList line, Point absoluteAnchorCoordinates, boolean isFirst) {
        LineSeg segment = RectilinearEdgeUtil.getSegment(line, isFirst);
        Point origin = segment.getOrigin();
        Point terminus = segment.getTerminus();
        if (segment.isVertical()) {
            origin.setX(absoluteAnchorCoordinates.x());
            terminus.setX(absoluteAnchorCoordinates.x());
        } else {
            origin.setY(absoluteAnchorCoordinates.y());
            terminus.setY(absoluteAnchorCoordinates.y());
        }
        if (isFirst) {
            line.setPoint(origin, 0);
            line.setPoint(terminus, 1);
        } else {
            line.setPoint(origin, line.size() - 1);
            line.setPoint(terminus, line.size() - 2);
        }
    }

    private static LineSeg getSegment(PointList line, boolean isFirst) {
        if (isFirst) {
            return new LineSeg(line.getFirstPoint(), line.getPoint(1));
        }
        return new LineSeg(line.getLastPoint(), line.getPoint(line.size() - 2));
    }

    private static boolean removeRedundantPoints(PointList line) {
        int initialNumberOfPoints = line.size();
        if (line.size() > 2) {
            PointList newLine = new PointList(line.size());
            newLine.addPoint(line.removePoint(0));
            while (line.size() >= 2) {
                Point p0 = newLine.getLastPoint();
                Point p1 = line.getPoint(0);
                Point p2 = line.getPoint(1);
                if (p0.x == p1.x && p0.x == p2.x) {
                    line.removePoint(0);
                    continue;
                }
                if (p0.y == p1.y && p0.y == p2.y) {
                    line.removePoint(0);
                    continue;
                }
                newLine.addPoint(line.removePoint(0));
            }
            while (line.size() > 0) {
                newLine.addPoint(line.removePoint(0));
            }
            line.removeAllPoints();
            line.addAll(newLine);
        }
        return line.size() != initialNumberOfPoints;
    }

    public static PointList computeRectilinearBendpoints(Rectangle srcAbsoluteBounds, Rectangle tgtAbsoluteBounds, Point srcPoint, Point tgtPoint) {
        PointList pointList = new PointList();
        pointList.addPoint(srcPoint);
        LineSeg srcSeg = RectilinearEdgeUtil.getBoundSideIntersection(srcPoint, srcAbsoluteBounds);
        LineSeg tgtSeg = RectilinearEdgeUtil.getBoundSideIntersection(tgtPoint, tgtAbsoluteBounds);
        if (srcSeg != null && tgtSeg != null) {
            if (srcSeg.isHorizontal()) {
                if (srcPoint.x != tgtPoint.x) {
                    if (tgtSeg.isHorizontal()) {
                        int middleY = (srcPoint.y + tgtPoint.y) / 2;
                        pointList.addPoint(new Point(srcPoint.x, middleY));
                        pointList.addPoint(new Point(tgtPoint.x, middleY));
                    } else {
                        pointList.addPoint(new Point(srcPoint.x, tgtPoint.y));
                    }
                }
            } else if (srcPoint.y != tgtPoint.y) {
                if (tgtSeg.isVertical()) {
                    int middleX = (srcPoint.x + tgtPoint.x) / 2;
                    pointList.addPoint(new Point(middleX, srcPoint.y));
                    pointList.addPoint(new Point(middleX, tgtPoint.y));
                } else {
                    pointList.addPoint(new Point(tgtPoint.x, srcPoint.y));
                }
            }
        }
        pointList.addPoint(tgtPoint);
        return pointList;
    }

    public static PointList computeRectilinearBendpointsSameSourceAndTarget(Rectangle srcAndTgtAbsoluteBounds, ConnectionNodeEditPart editPart) {
        Bendpoints bendpoints = ((Edge)editPart.getModel()).getBendpoints();
        RelativeBendpoints relativeBendpoints = (RelativeBendpoints)bendpoints;
        ConnectionEditPartQuery connectionEditPartQuery = new ConnectionEditPartQuery((ConnectionEditPart)editPart);
        PrecisionPoint sourceAnchorsAbsoluteLocation = connectionEditPartQuery.getCenteredAnchorsAbsoluteLocation(srcAndTgtAbsoluteBounds);
        PrecisionPoint targetAnchorsAbsoluteLocation = connectionEditPartQuery.getCenteredAnchorsAbsoluteLocation(srcAndTgtAbsoluteBounds);
        PointList initialPointList = new ConnectionQuery((Connection)editPart.getFigure()).getAbsolutePointList(relativeBendpoints, sourceAnchorsAbsoluteLocation, targetAnchorsAbsoluteLocation);
        EditPartQuery editPartQuery = new EditPartQuery((IGraphicalEditPart)editPart.getSource());
        int sourceSide = editPartQuery.getSideOfLocation(initialPointList.getFirstPoint());
        if (sourceSide == 0) {
            sourceSide = 16;
        }
        Option srcConnectionBendpoint = Options.newSome((Object)editPartQuery.getCenterOfSide(sourceSide));
        Point srcPoint = (Point)srcConnectionBendpoint.get();
        return RectilinearEdgeUtil.computeRectilinearBendpointsSameSourceAndTarget(srcAndTgtAbsoluteBounds, srcPoint, sourceSide);
    }

    public static PointList computeRectilinearBendpointsSameSourceAndTarget(Rectangle srcAndTgtAbsoluteBounds, Point srcPoint, int sourceSide) {
        PointList pointList = new PointList();
        pointList.addPoint(srcPoint);
        int offset = LayoutUtils.NEW_DEFAULT_CONTAINER_DIMENSION.height;
        if (1 == sourceSide) {
            Point newSecondPoint = new Point(srcPoint.x, srcAndTgtAbsoluteBounds.getTop().y - offset);
            pointList.addPoint(newSecondPoint);
            Point newThirdPoint = new Point(srcAndTgtAbsoluteBounds.getRight().x + offset, srcAndTgtAbsoluteBounds.getTop().y - offset);
            pointList.addPoint(newThirdPoint);
            Point newFourthPoint = new Point(srcAndTgtAbsoluteBounds.getRight().x + offset, srcAndTgtAbsoluteBounds.getRight().y);
            pointList.addPoint(newFourthPoint);
            pointList.addPoint(srcAndTgtAbsoluteBounds.getRight());
        } else if (16 == sourceSide) {
            Point newSecondPoint = new Point(srcAndTgtAbsoluteBounds.getRight().x + offset, srcPoint.y);
            pointList.addPoint(newSecondPoint);
            Point newThirdPoint = new Point(srcAndTgtAbsoluteBounds.getRight().x + offset, srcAndTgtAbsoluteBounds.getBottom().y + offset);
            pointList.addPoint(newThirdPoint);
            Point newFourthPoint = new Point(srcAndTgtAbsoluteBounds.getBottom().x, srcAndTgtAbsoluteBounds.getBottom().y + offset);
            pointList.addPoint(newFourthPoint);
            pointList.addPoint(srcAndTgtAbsoluteBounds.getBottom());
        } else if (4 == sourceSide) {
            Point newSecondPoint = new Point(srcPoint.x, srcAndTgtAbsoluteBounds.getBottom().y + offset);
            pointList.addPoint(newSecondPoint);
            Point newThirdPoint = new Point(srcAndTgtAbsoluteBounds.getLeft().x - offset, srcAndTgtAbsoluteBounds.getBottom().y + offset);
            pointList.addPoint(newThirdPoint);
            Point newFourthPoint = new Point(srcAndTgtAbsoluteBounds.getLeft().x - offset, srcAndTgtAbsoluteBounds.getLeft().y);
            pointList.addPoint(newFourthPoint);
            pointList.addPoint(srcAndTgtAbsoluteBounds.getLeft());
        } else if (8 == sourceSide) {
            Point newSecondPoint = new Point(srcAndTgtAbsoluteBounds.getLeft().x - offset, srcPoint.y);
            pointList.addPoint(newSecondPoint);
            Point newThirdPoint = new Point(srcAndTgtAbsoluteBounds.getLeft().x - offset, srcAndTgtAbsoluteBounds.getTop().y - offset);
            pointList.addPoint(newThirdPoint);
            Point newFourthPoint = new Point(srcAndTgtAbsoluteBounds.getTop().x, srcAndTgtAbsoluteBounds.getTop().y - offset);
            pointList.addPoint(newFourthPoint);
            pointList.addPoint(srcAndTgtAbsoluteBounds.getTop());
        }
        return pointList;
    }

    public static void alignBoundPointTowardAnchor(Rectangle figureBounds, Point point, Point absoluteAnchorCoordinates) {
        LineSeg segment = RectilinearEdgeUtil.getBoundSideIntersection(point, figureBounds);
        if (segment != null) {
            if (segment.isHorizontal()) {
                point.setX(absoluteAnchorCoordinates.x);
            } else {
                point.setY(absoluteAnchorCoordinates.y);
            }
        }
    }

    private static LineSeg getBoundSideIntersection(Point boundPoint, Rectangle bounds) {
        LineSeg seg = null;
        if (boundPoint != null && bounds != null) {
            Point topLeftCorner = new Point(bounds.x, bounds.y);
            Point topRightCorner = new Point(bounds.x + bounds.width, bounds.y);
            Point btmLeftCorner = new Point(bounds.x, bounds.y + bounds.height);
            Point btmRightCorner = new Point(bounds.x + bounds.width, bounds.y + bounds.height);
            if (bounds.x == boundPoint.x) {
                seg = new LineSeg(topLeftCorner, btmLeftCorner);
            } else if (bounds.x + bounds.width == boundPoint.x) {
                seg = new LineSeg(topRightCorner, btmRightCorner);
            } else if (bounds.y == boundPoint.y) {
                seg = new LineSeg(topLeftCorner, topRightCorner);
            } else if (bounds.y + bounds.height == boundPoint.y) {
                seg = new LineSeg(btmLeftCorner, btmRightCorner);
            }
        }
        return seg;
    }

    public static PointList normalizeToStraightLineTolerance(PointList line, int tolerance) {
        if (line == null || line.size() < 3) {
            return line;
        }
        int i = 0;
        while (i < line.size() - 1) {
            Point pt1 = line.getPoint(i);
            Point pt2 = line.getPoint(i + 1);
            if (Math.abs(pt1.y - pt2.y) < tolerance) {
                line.setPoint(new Point(pt2.x, pt1.y), i + 1);
            } else if (Math.abs(pt1.x - pt2.x) < tolerance) {
                line.setPoint(new Point(pt1.x, pt2.y), i + 1);
            }
            ++i;
        }
        PointList newLine = new PointList();
        newLine.addPoint(line.getPoint(0));
        int i2 = 1;
        while (i2 < line.size() - 1) {
            Point pt1 = line.getPoint(i2 - 1);
            Point pt2 = line.getPoint(i2);
            Point pt3 = line.getPoint(i2 + 1);
            if (!(pt1.x == pt2.x && pt3.x == pt2.x || pt1.y == pt2.y && pt3.y == pt2.y)) {
                newLine.addPoint(pt2);
            }
            ++i2;
        }
        newLine.addPoint(line.getPoint(line.size() - 1));
        return newLine;
    }
}

