/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.properties.section.description.containermapping;

import org.eclipse.sirius.diagram.ContainerLayout;
import org.eclipse.sirius.diagram.business.api.query.ContainerMappingQuery;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.editor.properties.sections.description.containermapping.ContainerMappingChildrenPresentationPropertySection;
import org.eclipse.sirius.diagram.model.business.internal.helper.MappingHelper;
import org.eclipse.sirius.editor.editorPlugin.SiriusEditor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;

public class ContainerMappingChildrenPresentationPropertySectionSpec
extends ContainerMappingChildrenPresentationPropertySection {
    protected void makeWrittable() {
        super.makeWrittable();
        if (this.button != null && this.eObject instanceof ContainerMapping) {
            ContainerMapping containerMapping = (ContainerMapping)this.eObject;
            Option<String> experimentalStackButtons = this.shouldMarkCompartmentsExperimental(containerMapping);
            this.updateControls(experimentalStackButtons);
        }
    }

    private Option<String> shouldMarkCompartmentsExperimental(ContainerMapping containerMapping) {
        boolean experimental = false;
        StringBuilder message = new StringBuilder("Experimental");
        experimental = new ContainerMappingQuery(containerMapping).isRegion();
        if (experimental) {
            message.append(" - the mapping will produce containers which will be Region and RegionContainer");
        }
        for (ContainerMapping subContainerMapping : MappingHelper.getAllContainerMappings((ContainerMapping)containerMapping)) {
            boolean bl = experimental = experimental || new ContainerMappingQuery(subContainerMapping).isRegionContainer();
            if (!experimental) continue;
            message.append(" - the children mapping will produce containers which will be Region and RegionContainer");
            break;
        }
        message.append(".");
        return experimental ? Options.newSome((Object)message.toString()) : Options.newNone();
    }

    private void updateControls(Option<String> experimentalStackButtons) {
        String hStackButtonText = this.getText(ContainerLayout.HORIZONTAL_STACK);
        String vStackButtonText = this.getText(ContainerLayout.VERTICAL_STACK);
        boolean needsLayout = false;
        Button[] buttonArray = this.button;
        int n = this.button.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            if (hStackButtonText.equals(b.getText()) || vStackButtonText.equals(b.getText())) {
                needsLayout = this.updateButton(b, experimentalStackButtons) || needsLayout;
            }
            ++n2;
        }
        if (needsLayout) {
            this.composite.layout();
        }
    }

    private boolean updateButton(Button b, Option<String> experimentalStackButtons) {
        boolean needsLayout = false;
        if (experimentalStackButtons.some()) {
            b.setToolTipText((String)experimentalStackButtons.get());
            Font f = b.getFont();
            if (f != null && f.getFontData().length > 0) {
                FontData fontData = f.getFontData()[0];
                Font italic = SiriusEditor.getFontRegistry().getItalic(fontData.getName());
                if (italic != null) {
                    b.setFont(italic);
                }
            }
        } else {
            b.setToolTipText(null);
            Font f = b.getFont();
            if (f != null && f.getFontData().length > 0) {
                FontData fontData = f.getFontData()[0];
                Font normal = SiriusEditor.getFontRegistry().get(fontData.getName());
                if (normal != null) {
                    b.setFont(normal);
                    needsLayout = true;
                }
            }
        }
        return needsLayout;
    }
}

