/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.editor.properties.sections.description.identifiedelement;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.editor.properties.sections.description.identifiedelement.IdentifiedElementLabelPropertySection;
import org.eclipse.sirius.editor.properties.sections.description.identifiedelement.IdentifiedElementNamePropertySection;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class IdentifiedElementNamePropertySectionSpec
extends IdentifiedElementNamePropertySection {
    private AtomicBoolean duringLabelTextRefresh = new AtomicBoolean(false);
    private static final int LABEL_WIDTH = 100;
    private SmartIdentifiedElementLabelPropertySection labelSection;

    @Override
    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.labelSection != null) {
            this.labelSection.setInput(part, selection);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.labelSection != null) {
            this.labelSection.refresh();
        }
    }

    @Override
    public void disableModelUpdating() {
        super.disableModelUpdating();
        if (this.labelSection != null) {
            this.labelSection.disableModelUpdating();
        }
    }

    @Override
    public void enableModelUpdating() {
        super.enableModelUpdating();
        if (this.labelSection != null) {
            this.labelSection.enableModelUpdating();
        }
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        Composite topLevel = tabbedPropertySheetPage.getWidgetFactory().createComposite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginLeft = -5;
        layout.marginTop = -5;
        layout.marginBottom = -5;
        layout.marginRight = -5;
        topLevel.setLayout((Layout)layout);
        super.createControls(topLevel, tabbedPropertySheetPage);
        this.createLabelSection(tabbedPropertySheetPage, topLevel);
    }

    private void createLabelSection(TabbedPropertySheetPage tabbedPropertySheetPage, Composite topLevel) {
        this.labelSection = new SmartIdentifiedElementLabelPropertySection();
        this.labelSection.createControls(topLevel, tabbedPropertySheetPage);
        this.composite.setLayoutData((Object)new GridData(768));
        this.labelSection.getComposite().setLayoutData((Object)new GridData(768));
        FormData oldData = (FormData)this.labelSection.getText().getLayoutData();
        oldData.left = new FormAttachment(0, 100);
        this.labelSection.getText().setLayoutData((Object)oldData);
        this.labelSection.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!IdentifiedElementNamePropertySectionSpec.this.duringLabelTextRefresh.get()) {
                    IdentifiedElementNamePropertySectionSpec.this.labelSection.setHasExplicitValue();
                    IdentifiedElementNamePropertySectionSpec.this.labelSection.refreshTextColor();
                }
            }
        });
    }

    private class SmartIdentifiedElementLabelPropertySection
    extends IdentifiedElementLabelPropertySection {
        private boolean hasExplicitValue = false;

        private SmartIdentifiedElementLabelPropertySection() {
        }

        protected void setHasExplicitValue() {
            this.hasExplicitValue = true;
        }

        private String getIdText() {
            return IdentifiedElementNamePropertySectionSpec.this.getFeatureAsText();
        }

        @Override
        public void setInput(IWorkbenchPart part, ISelection selection) {
            super.setInput(part, selection);
            this.hasExplicitValue = this.eObject.eIsSet((EStructuralFeature)this.getFeature());
            this.refresh();
        }

        @Override
        public void refresh() {
            IdentifiedElementNamePropertySectionSpec.this.duringLabelTextRefresh.set(true);
            super.refresh();
            if (!this.hasExplicitValue) {
                this.setText(this.getIdText());
            }
            IdentifiedElementNamePropertySectionSpec.this.duringLabelTextRefresh.set(false);
            this.refreshTextColor();
        }

        @Override
        protected void handleTextModified() {
            if (this.hasExplicitValue) {
                super.handleTextModified();
            }
        }

        @Override
        public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
            super.createControls(parent, tabbedPropertySheetPage);
            this.text.addFocusListener(new FocusListener(){

                public void focusLost(FocusEvent e) {
                    if ("".equals(SmartIdentifiedElementLabelPropertySection.this.text.getText())) {
                        SmartIdentifiedElementLabelPropertySection.this.setText(SmartIdentifiedElementLabelPropertySection.this.getIdText());
                        SmartIdentifiedElementLabelPropertySection.this.hasExplicitValue = false;
                        SmartIdentifiedElementLabelPropertySection.this.refreshTextColor();
                    }
                }

                public void focusGained(FocusEvent e) {
                    if (SmartIdentifiedElementLabelPropertySection.this.getIdText().equals(SmartIdentifiedElementLabelPropertySection.this.text.getText())) {
                        SmartIdentifiedElementLabelPropertySection.this.setText("");
                    } else {
                        SmartIdentifiedElementLabelPropertySection.this.getText().selectAll();
                    }
                }
            });
            this.text.addMouseListener(new MouseListener(){

                public void mouseUp(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                    if (SmartIdentifiedElementLabelPropertySection.this.getIdText().equals(SmartIdentifiedElementLabelPropertySection.this.text.getText())) {
                        SmartIdentifiedElementLabelPropertySection.this.setText("");
                    } else {
                        SmartIdentifiedElementLabelPropertySection.this.getText().selectAll();
                    }
                }

                public void mouseDoubleClick(MouseEvent e) {
                }
            });
        }

        public void refreshTextColor() {
            Device device = this.text.getForeground().getDevice();
            Color textColor = this.hasExplicitValue ? device.getSystemColor(2) : device.getSystemColor(15);
            this.getText().setForeground(textColor);
        }
    }
}

