/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.lm.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.launch.core.lm.delegates.DefaultLaunchManagerDelegate;
import org.eclipse.tcf.te.launch.core.lm.interfaces.ILaunchManagerDelegate;
import org.eclipse.tcf.te.runtime.extensions.AbstractExtensionPointManager;
import org.eclipse.tcf.te.runtime.extensions.ExecutableExtensionProxy;
import org.eclipse.tcf.te.runtime.interfaces.extensions.IExecutableExtension;

public class ExtensionPointManager
extends AbstractExtensionPointManager<ILaunchManagerDelegate> {
    private final ILaunchManagerDelegate defaultDelegate = new DefaultLaunchManagerDelegate();

    public static ExtensionPointManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    ExtensionPointManager() {
    }

    protected String getConfigurationElementName() {
        return "delegate";
    }

    protected String getExtensionPointId() {
        return "org.eclipse.tcf.te.launch.core.launchManagerDelegates";
    }

    public ILaunchManagerDelegate[] getLaunchManagerDelegates() {
        ArrayList<ILaunchManagerDelegate> delegates = new ArrayList<ILaunchManagerDelegate>();
        for (ExecutableExtensionProxy proxy : this.getExtensions().values()) {
            IExecutableExtension candidate = (IExecutableExtension)proxy.getInstance();
            if (!(candidate instanceof ILaunchManagerDelegate) || delegates.contains(candidate)) continue;
            delegates.add((ILaunchManagerDelegate)candidate);
        }
        return delegates.toArray(new ILaunchManagerDelegate[delegates.size()]);
    }

    public ILaunchManagerDelegate getLaunchManagerDelegate(String id) {
        Assert.isNotNull((Object)id);
        ILaunchManagerDelegate delegate = null;
        if (this.getExtensions().containsKey(id)) {
            delegate = (ILaunchManagerDelegate)((ExecutableExtensionProxy)this.getExtensions().get(id)).getInstance();
        }
        return delegate != null ? delegate : this.getDefaultLaunchManagerDelegate();
    }

    public ILaunchManagerDelegate getDefaultLaunchManagerDelegate() {
        return this.defaultDelegate;
    }

    private static class LazyInstanceHolder {
        public static ExtensionPointManager instance = new ExtensionPointManager();

        private LazyInstanceHolder() {
        }
    }
}

