/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.selection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.core.cdt.elf.ElfUtils;
import org.eclipse.tcf.te.launch.core.selection.LaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.ProjectSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.launch.ui.nls.Messages;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNodeProvider;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class LaunchSelectionManager {
    public static final String PART_ID_TE_VIEW = "org.eclipse.tcf.te.ui.views.View";
    public static final String PART_ID_PROJECT_VIEW = "org.eclipse.ui.navigator.ProjectExplorer";
    public static final String PART_ID_DEBUG_VIEW = "org.eclipse.debug.ui.DebugView";
    private IStructuredSelection lastRemoteCtxInputSelection = null;
    private Map<IModelNode, Set<IModelNode>> lastRemoteCtxOutputSelections = null;
    private IStructuredSelection lastProjectInputSelection = null;
    private long lastProjectHash = 0L;
    private Map<IProject, Set<IPath>> lastProjectOutputSelections = null;

    public static LaunchSelectionManager getInstance() {
        return LazyInstanceHolder.instance;
    }

    LaunchSelectionManager() {
    }

    public ILaunchSelection getLaunchSelection(ILaunchConfigurationType type, String mode, String preferredPartId) {
        return new LaunchSelection(mode, this.getSelectionContexts(type, mode, preferredPartId));
    }

    private ISelectionContext[] getSelectionContexts(ILaunchConfigurationType type, String mode, String preferredPartId) {
        ArrayList<ISelectionContext> contexts = new ArrayList<ISelectionContext>();
        contexts.addAll(this.getSelectionContextsFor(PART_ID_TE_VIEW, type, mode, PART_ID_TE_VIEW.equalsIgnoreCase(preferredPartId)));
        contexts.addAll(this.getSelectionContextsFor(PART_ID_PROJECT_VIEW, type, mode, PART_ID_PROJECT_VIEW.equalsIgnoreCase(preferredPartId)));
        return contexts.toArray(new ISelectionContext[contexts.size()]);
    }

    public List<ISelectionContext> getSelectionContextsFor(String partId, ILaunchConfigurationType type, String mode, boolean preferedPart) {
        ArrayList<ISelectionContext> contexts;
        block3: {
            block2: {
                contexts = new ArrayList<ISelectionContext>();
                if (!PART_ID_TE_VIEW.equalsIgnoreCase(partId)) break block2;
                Map<IModelNode, Set<IModelNode>> remoteCtxSelections = this.getRemoteCtxSelections(LaunchSelectionManager.getPartSelection(PART_ID_TE_VIEW));
                for (Map.Entry<IModelNode, Set<IModelNode>> remoteCtx : remoteCtxSelections.entrySet()) {
                    contexts.add((ISelectionContext)new RemoteSelectionContext(remoteCtx.getKey(), remoteCtx.getValue().toArray(), preferedPart));
                }
                break block3;
            }
            if (!PART_ID_PROJECT_VIEW.equalsIgnoreCase(partId)) break block3;
            Map<IProject, Set<IPath>> projectSelections = this.getProjectSelections(LaunchSelectionManager.getPartSelection(PART_ID_PROJECT_VIEW), true);
            for (Map.Entry<IProject, Set<IPath>> prj : projectSelections.entrySet()) {
                contexts.add((ISelectionContext)new ProjectSelectionContext(prj.getKey(), prj.getValue().toArray(), preferedPart));
            }
        }
        return contexts;
    }

    private Map<IModelNode, Set<IModelNode>> getRemoteCtxSelections(IStructuredSelection structSel) {
        if (structSel != null && structSel.equals(this.lastRemoteCtxInputSelection) && this.lastRemoteCtxOutputSelections != null) {
            return this.lastRemoteCtxOutputSelections;
        }
        HashMap<IModelNode, Set<IModelNode>> remoteCtxSelections = new HashMap<IModelNode, Set<IModelNode>>();
        if (structSel != null && !structSel.isEmpty()) {
            Object[] objectArray = structSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertiesAccessService service;
                Object sel = objectArray[n2];
                IModelNode remoteCtx = null;
                IModelNode node = null;
                if (sel instanceof LaunchNode && ((LaunchNode)((Object)sel)).getModel().getModelRoot() instanceof IModelNode) {
                    node = (IModelNode)((LaunchNode)((Object)sel)).getModel().getModelRoot();
                } else if (sel instanceof IModelNodeProvider) {
                    node = ((IModelNodeProvider)sel).getModelNode();
                } else if (sel instanceof IModelNode) {
                    node = (IModelNode)sel;
                }
                if (node != null && (service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)node, IPropertiesAccessService.class)) != null) {
                    remoteCtx = node;
                    IModelNode parent = (IModelNode)service.getParent((Object)node);
                    while (parent != null) {
                        remoteCtx = parent;
                        parent = (IModelNode)service.getParent((Object)parent);
                    }
                }
                if (remoteCtx != null) {
                    Set<IModelNode> nodes;
                    if (!remoteCtxSelections.containsKey(remoteCtx)) {
                        nodes = new HashSet();
                        remoteCtxSelections.put(remoteCtx, nodes);
                    } else {
                        nodes = (Set)remoteCtxSelections.get(remoteCtx);
                    }
                    if (node != null) {
                        nodes.add(node);
                    }
                }
                ++n2;
            }
        }
        this.lastRemoteCtxInputSelection = structSel;
        this.lastRemoteCtxOutputSelections = remoteCtxSelections;
        return this.lastRemoteCtxOutputSelections;
    }

    private long getProjectHash(IStructuredSelection structSel) {
        long hash = 0L;
        if (structSel != null) {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            Object[] objectArray = structSel.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                IProject prj = null;
                IResource resource = null;
                if (sel instanceof LaunchNode && ((LaunchNode)((Object)sel)).getModel().getModelRoot() instanceof IResource) {
                    sel = ((LaunchNode)((Object)sel)).getModel().getModelRoot();
                }
                if (sel instanceof IProject) {
                    prj = (IProject)sel;
                } else {
                    resource = sel instanceof IResource ? (IResource)sel : (sel instanceof IAdaptable ? (IResource)((IAdaptable)sel).getAdapter(IResource.class) : (IResource)Platform.getAdapterManager().loadAdapter(sel, IResource.class.getName()));
                    IProject iProject = prj = resource != null ? resource.getProject() : null;
                }
                if (prj != null && !projects.contains(prj)) {
                    projects.add(prj);
                    hash += (long)prj.hashCode();
                } else {
                    hash += (long)sel.hashCode();
                }
                ++n2;
            }
            projects.clear();
        }
        return hash;
    }

    public Map<IProject, Set<IPath>> getProjectSelections(IStructuredSelection selection, boolean storeToCache) {
        long projectHash = 0L;
        if (selection != null && selection.equals(this.lastProjectInputSelection) && this.lastProjectOutputSelections != null) {
            projectHash = this.getProjectHash(selection);
            if (this.lastProjectHash == 0L || this.lastProjectHash == projectHash) {
                return this.lastProjectOutputSelections;
            }
        }
        HashMap<IProject, Set<IPath>> projectSelections = new HashMap<IProject, Set<IPath>>();
        if (selection != null && !selection.isEmpty()) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                IProject prj = null;
                IPath location = null;
                if (sel instanceof LaunchNode && ((LaunchNode)((Object)sel)).getModel().getModelRoot() instanceof IProject) {
                    prj = (IProject)((LaunchNode)((Object)sel)).getModel().getModelRoot();
                } else if (sel instanceof IProject) {
                    prj = (IProject)sel;
                } else if (sel instanceof IFile) {
                    IFile file = (IFile)sel;
                    prj = file.getProject();
                    if (this.getLocation((IResource)file) != null) {
                        File filePath = this.getLocation((IResource)file).toFile();
                        try {
                            int elfType = ElfUtils.getELFType((File)filePath);
                            if (file.exists() && (elfType == 1 || elfType == 3)) {
                                location = file.getLocation();
                            }
                        }
                        catch (IOException e) {
                            if (Platform.inDebugMode()) {
                                Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.LaunchSelectionManager_error_failedToDetermineElfType, (Object)filePath.getAbsolutePath()), (Throwable)e);
                                UIPlugin.getDefault().getLog().log((IStatus)status);
                            }
                        }
                    }
                } else {
                    IResource resource = (IResource)Platform.getAdapterManager().loadAdapter(sel, IResource.class.getName());
                    if (resource != null) {
                        prj = resource.getProject();
                        location = this.getLocation(resource);
                        if (location != null) {
                            try {
                                int elfType = ElfUtils.getELFType((File)location.toFile());
                                if (elfType != 1 && elfType != 3) {
                                    location = null;
                                }
                            }
                            catch (Exception e) {
                                if (Platform.inDebugMode()) {
                                    Status status = new Status(4, UIPlugin.getUniqueIdentifier(), NLS.bind((String)Messages.LaunchSelectionManager_error_failedToDetermineElfType, (Object)location.toFile().getAbsolutePath()), (Throwable)e);
                                    UIPlugin.getDefault().getLog().log((IStatus)status);
                                }
                                location = null;
                            }
                        }
                    }
                }
                if (prj != null && (location == null || location.toFile().isDirectory())) {
                    location = this.getFirstExeLocation(prj);
                }
                if (prj != null) {
                    Set<IPath> nodes;
                    if (!projectSelections.containsKey(prj)) {
                        nodes = new HashSet();
                        projectSelections.put(prj, nodes);
                    } else {
                        nodes = (Set)projectSelections.get(prj);
                    }
                    if (location != null) {
                        nodes.add(location);
                    }
                }
                ++n2;
            }
        }
        if (storeToCache) {
            this.lastProjectInputSelection = selection;
            this.lastProjectHash = projectHash != 0L ? projectHash : this.getProjectHash(selection);
            this.lastProjectOutputSelections = projectSelections;
        }
        return storeToCache ? this.lastProjectOutputSelections : projectSelections;
    }

    public static IStructuredSelection getPartSelection(String partId) {
        ISelection sel;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (partId != null && window != null && window.getActivePage() != null && (sel = window.getActivePage().getSelection(partId)) instanceof IStructuredSelection) {
            return (IStructuredSelection)sel;
        }
        return null;
    }

    public IPath getFirstExeLocation(IProject prj) {
        return null;
    }

    private IPath getLocation(IResource resource) {
        return resource != null ? resource.getLocation() : null;
    }

    private static class LazyInstanceHolder {
        public static LaunchSelectionManager instance = new LaunchSelectionManager();

        private LazyInstanceHolder() {
        }
    }
}

