/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.concurrent;

import java.util.concurrent.TimeoutException;

public class Rendezvous {
    private boolean arrived;

    public synchronized void arrive() {
        this.arrived = true;
        this.notifyAll();
    }

    public synchronized void waiting(long timeout) throws TimeoutException {
        long now = System.currentTimeMillis();
        while (!(this.arrived || timeout > 0L && System.currentTimeMillis() - now >= timeout)) {
            try {
                this.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.arrived) {
            throw new TimeoutException();
        }
    }

    public synchronized void waiting() throws TimeoutException {
        this.waiting(0L);
    }

    public synchronized void reset() {
        this.arrived = false;
    }
}

