/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.wizards.newWizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.wizards.interfaces.INewWizardProvider;
import org.eclipse.tcf.te.ui.wizards.newWizard.NewWizardCategory;
import org.eclipse.ui.internal.wizards.AbstractExtensionWizardRegistry;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;

public final class NewWizardRegistry
extends AbstractExtensionWizardRegistry {
    private List<INewWizardProvider> newWizardProvider = new ArrayList<INewWizardProvider>();
    private IWizardCategory root;

    NewWizardRegistry() {
    }

    public static NewWizardRegistry getInstance() {
        return LazyInstance.instance;
    }

    protected void doInitialize() {
        super.doInitialize();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(this.getPlugin(), "wizardProviders");
        IConfigurationElement[] iConfigurationElementArray = point.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (element.getName().equals("wizardProvider")) {
                try {
                    INewWizardProvider provider = (INewWizardProvider)element.createExecutableExtension("class");
                    this.newWizardProvider.add(provider);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        if (!this.newWizardProvider.isEmpty()) {
            NewWizardCategory newRoot = new NewWizardCategory(super.getRootCategory());
            for (INewWizardProvider provider : this.newWizardProvider) {
                IWizardCategory[] iWizardCategoryArray = provider.getCategories();
                int n3 = iWizardCategoryArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IWizardCategory category = iWizardCategoryArray[n4];
                    IWizardCategory existing = newRoot.findCategory(category.getId());
                    if (existing != null) {
                        if (existing instanceof NewWizardCategory) {
                            this.mergeCategory(category, (NewWizardCategory)existing);
                        } else {
                            NewWizardCategory dst = new NewWizardCategory(existing);
                            if (super.getRootCategory().equals(dst.getParent())) {
                                dst.setParent(newRoot);
                            }
                            this.mergeCategory(category, dst);
                            newRoot.removeCategory(existing);
                            newRoot.addCategory(dst);
                        }
                    } else {
                        newRoot.addCategory(category);
                    }
                    ++n4;
                }
            }
            this.root = newRoot;
        } else {
            this.root = super.getRootCategory();
        }
    }

    private void mergeCategory(IWizardCategory src, NewWizardCategory dst) {
        IWizardDescriptor[] wizards;
        IWizardCategory[] categories;
        Assert.isNotNull((Object)src);
        Assert.isNotNull((Object)dst);
        IWizardCategory[] iWizardCategoryArray = categories = src.getCategories();
        int n = categories.length;
        int n2 = 0;
        while (n2 < n) {
            IWizardCategory category = iWizardCategoryArray[n2];
            IWizardCategory existing = dst.findCategory(category.getId());
            if (existing != null) {
                if (existing instanceof NewWizardCategory) {
                    this.mergeCategory(category, (NewWizardCategory)existing);
                } else {
                    NewWizardCategory merged = new NewWizardCategory(existing);
                    this.mergeCategory(category, merged);
                    dst.addCategory(merged);
                }
            } else {
                dst.addCategory(category);
            }
            ++n2;
        }
        IWizardDescriptor[] iWizardDescriptorArray = wizards = src.getWizards();
        int n3 = wizards.length;
        n = 0;
        while (n < n3) {
            IWizardDescriptor wizard = iWizardDescriptorArray[n];
            if (dst.findWizard(wizard.getId()) == null) {
                dst.addWizard(wizard);
            }
            ++n;
        }
    }

    protected String getExtensionPoint() {
        return "newWizards";
    }

    protected String getPlugin() {
        return UIPlugin.getUniqueIdentifier();
    }

    public IWizardDescriptor findWizard(String id) {
        return this.getRootCategory().findWizard(id);
    }

    public IWizardDescriptor[] getPrimaryWizards() {
        return super.getPrimaryWizards();
    }

    public IWizardCategory findCategory(String id) {
        IWizardCategory root = this.getRootCategory();
        if (root instanceof NewWizardCategory) {
            return ((NewWizardCategory)root).findCategory(id);
        }
        return super.findCategory(id);
    }

    public IWizardCategory getRootCategory() {
        this.initialize();
        return this.root;
    }

    public IWizardDescriptor[] getCommonWizards(ISelection selection) {
        this.initialize();
        ArrayList<IWizardDescriptor> allWizards = new ArrayList<IWizardDescriptor>();
        for (INewWizardProvider provider : this.newWizardProvider) {
            IWizardDescriptor[] wizards = provider.getCommonWizards(selection);
            if (wizards == null || wizards.length <= 0) continue;
            allWizards.addAll(Arrays.asList(wizards));
        }
        return allWizards.toArray(new IWizardDescriptor[allWizards.size()]);
    }

    private static class LazyInstance {
        public static NewWizardRegistry instance = new NewWizardRegistry();

        private LazyInstance() {
        }
    }
}

