/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.connector;

import java.io.OutputStream;
import java.util.Optional;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm.internal.terminal.control.impl.TerminalMessages;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsStore;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.provisional.api.provider.TerminalConnectorImpl;

public class TerminalConnector
implements ITerminalConnector {
    private final Factory fTerminalConnectorFactory;
    private final String fName;
    private final String fId;
    private final boolean fHidden;
    private TerminalConnectorImpl fConnector;
    private Exception fException;
    private ISettingsStore fStore;

    public TerminalConnector(Factory terminalConnectorFactory, String id, String name, boolean hidden) {
        this.fTerminalConnectorFactory = terminalConnectorFactory;
        this.fId = id;
        this.fName = name;
        this.fHidden = hidden;
    }

    @Override
    public String getInitializationErrorMessage() {
        this.getConnectorImpl();
        if (this.fException != null) {
            return this.fException.getLocalizedMessage();
        }
        return null;
    }

    @Override
    public String getId() {
        return this.fId;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isHidden() {
        return this.fHidden;
    }

    private TerminalConnectorImpl getConnectorImpl() {
        if (!this.isInitialized()) {
            try {
                this.fConnector = this.fTerminalConnectorFactory.makeConnector();
                this.fConnector.initialize();
            }
            catch (Exception e) {
                this.fException = e;
                this.fConnector = new TerminalConnectorImpl(){

                    @Override
                    public void connect(ITerminalControl control) {
                        control.setState(TerminalState.CLOSED);
                        control.setMsg(TerminalConnector.this.getInitializationErrorMessage());
                    }

                    @Override
                    public OutputStream getTerminalToRemoteStream() {
                        return null;
                    }

                    @Override
                    public String getSettingsSummary() {
                        return null;
                    }
                };
                Logger.logException(e);
            }
            if (this.fConnector != null && this.fStore != null) {
                this.fConnector.load(this.fStore);
            }
        }
        return this.fConnector;
    }

    @Override
    public boolean isInitialized() {
        return this.fConnector != null || this.fException != null;
    }

    @Override
    public void connect(ITerminalControl control) {
        this.getConnectorImpl().connect(control);
    }

    @Override
    public void disconnect() {
        this.getConnectorImpl().disconnect();
    }

    @Override
    public OutputStream getTerminalToRemoteStream() {
        return this.getConnectorImpl().getTerminalToRemoteStream();
    }

    @Override
    public String getSettingsSummary() {
        if (this.fConnector != null) {
            return this.getConnectorImpl().getSettingsSummary();
        }
        return TerminalMessages.NotInitialized;
    }

    @Override
    public boolean isLocalEcho() {
        return this.getConnectorImpl().isLocalEcho();
    }

    @Override
    public void load(ISettingsStore store) {
        if (this.fConnector == null) {
            this.fStore = store;
        } else {
            this.getConnectorImpl().load(store);
        }
    }

    @Override
    public void setDefaultSettings() {
        this.getConnectorImpl().setDefaultSettings();
    }

    @Override
    public void save(ISettingsStore store) {
        if (this.fConnector != null) {
            this.getConnectorImpl().save(store);
        }
    }

    @Override
    public void setTerminalSize(int newWidth, int newHeight) {
        if (this.fConnector != null) {
            this.fConnector.setTerminalSize(newWidth, newHeight);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        TerminalConnectorImpl connector = null;
        if (this.isInitialized()) {
            connector = this.getConnectorImpl();
        }
        if (connector != null) {
            if (connector instanceof IAdaptable) {
                Object result = ((IAdaptable)connector).getAdapter(adapter);
                if (result == null) {
                    result = Platform.getAdapterManager().getAdapter((Object)connector, adapter);
                }
                if (result != null) {
                    return adapter.cast(result);
                }
            }
            if (adapter.isInstance(connector)) {
                return adapter.cast(connector);
            }
        }
        return (T)Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    @Override
    public Optional<String> getWorkingDirectory() {
        if (this.fConnector != null) {
            return this.fConnector.getWorkingDirectory();
        }
        return Optional.empty();
    }

    public static interface Factory {
        public TerminalConnectorImpl makeConnector() throws Exception;
    }
}

