/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;

public abstract class Property
implements IAdaptable {
    public static final Object UNKNOWN_VALUE = new Object(){

        public String toString() {
            return "UNKNOWN_VALUE";
        }
    };
    protected final PropertyEditor m_editor;
    private PropertyCategory m_category = PropertyCategory.NORMAL;
    private Map<Object, Object> m_arbitraryMap;

    public Property(PropertyEditor editor) {
        this.m_editor = editor;
    }

    public abstract String getTitle();

    public abstract boolean isModified() throws Exception;

    public final PropertyCategory getCategory() {
        return this.m_category;
    }

    public final void setCategory(PropertyCategory category) {
        this.m_category = category;
    }

    public abstract Object getValue() throws Exception;

    public abstract void setValue(Object var1) throws Exception;

    public final PropertyEditor getEditor() {
        return this.m_editor;
    }

    public Property getComposite(Property[] properties) {
        return null;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public final void putArbitraryValue(Object key, Object value) {
        if (this.m_arbitraryMap == null) {
            this.m_arbitraryMap = new HashMap<Object, Object>();
        }
        this.m_arbitraryMap.put(key, value);
    }

    public final Object getArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            return this.m_arbitraryMap.get(key);
        }
        return null;
    }

    public final void removeArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            this.m_arbitraryMap.remove(key);
        }
    }
}

