/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathsBlock;

public class BuildPathsPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    public static final String PROP_ID = "org.eclipse.wst.jsdt.ui.propertyPages.BuildPathsPropertyPage";
    private static final String PAGE_SETTINGS = "BuildPathsPropertyPage";
    private static final String INDEX = "pageIndex";
    public static final Object DATA_ADD_ENTRY = "add_classpath_entry";
    public static final Object DATA_REVEAL_ENTRY = "select_classpath_entry";
    public static final Object DATA_REVEAL_ATTRIBUTE_KEY = "select_classpath_attribute_key";
    public static final String DATA_PAGE_INDEX = "pageIndex";
    public static final Object DATA_BLOCK = "block_until_buildpath_applied";
    private BuildPathsBlock fBuildPathsBlock;
    private boolean fBlockOnApply = false;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IProject project = this.getProject();
        Control result = project == null || !this.isJavaProject(project) ? this.createWithoutJava(parent) : (!project.isOpen() ? this.createForClosedProject(parent) : this.createWithJava(parent, project));
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.build_path_property_page_context");
    }

    private IDialogSettings getSettings() {
        IDialogSettings javaSettings = JavaScriptPlugin.getDefault().getDialogSettings();
        IDialogSettings pageSettings = javaSettings.getSection(PAGE_SETTINGS);
        if (pageSettings == null) {
            pageSettings = javaSettings.addNewSection(PAGE_SETTINGS);
            pageSettings.put("pageIndex", 0);
        }
        return pageSettings;
    }

    public void setVisible(boolean visible) {
        if (this.fBuildPathsBlock != null) {
            if (!visible) {
                this.fBuildPathsBlock.aboutToDispose();
                if (this.fBuildPathsBlock.hasChangesInDialog()) {
                    String title = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_title;
                    String message = PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_message;
                    String[] buttonLabels = new String[]{PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_save, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_discard, PreferencesMessages.BuildPathsPropertyPage_unsavedchanges_button_ignore};
                    MessageDialog dialog = new MessageDialog(this.getShell(), title, null, message, 3, buttonLabels, 0);
                    int res = dialog.open();
                    if (res == 0) {
                        this.performOk();
                    } else if (res == 1) {
                        this.fBuildPathsBlock.init(JavaScriptCore.create((IProject)this.getProject()), null);
                    }
                }
            } else {
                this.fBuildPathsBlock.aboutToShow();
                if (!this.fBuildPathsBlock.hasChangesInDialog() && this.fBuildPathsBlock.hasChangesInClasspathFile()) {
                    this.fBuildPathsBlock.init(JavaScriptCore.create((IProject)this.getProject()), null);
                }
            }
        }
        super.setVisible(visible);
    }

    private Control createWithJava(Composite parent, IProject project) {
        IWorkbenchPreferenceContainer pageContainer = null;
        IPreferencePageContainer container = this.getContainer();
        if (container instanceof IWorkbenchPreferenceContainer) {
            pageContainer = (IWorkbenchPreferenceContainer)container;
        }
        this.fBuildPathsBlock = new BuildPathsBlock(new BusyIndicatorRunnableContext(), this, this.getSettings().getInt("pageIndex"), false, pageContainer);
        this.fBuildPathsBlock.init(JavaScriptCore.create((IProject)project), null);
        return this.fBuildPathsBlock.createControl(parent);
    }

    private Control createWithoutJava(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_no_java_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private Control createForClosedProject(Composite parent) {
        Label label = new Label(parent, 16384);
        label.setText(PreferencesMessages.BuildPathsPropertyPage_closed_project_message);
        this.fBuildPathsBlock = null;
        this.setValid(true);
        return label;
    }

    private IProject getProject() {
        IAdaptable adaptable = this.getElement();
        if (adaptable != null) {
            IJavaScriptProject elem = (IJavaScriptProject)adaptable.getAdapter(IJavaScriptProject.class);
            if (elem != null) {
                return elem.getProject();
            }
            return (IProject)adaptable.getAdapter(IProject.class);
        }
        return null;
    }

    private boolean isJavaProject(IProject proj) {
        try {
            return proj.hasNature("org.eclipse.wst.jsdt.core.jsNature");
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
            return false;
        }
    }

    public boolean performOk() {
        if (this.fBuildPathsBlock != null) {
            this.fBuildPathsBlock.aboutToDispose();
            this.getSettings().put("pageIndex", this.fBuildPathsBlock.getPageIndex());
            if (this.fBuildPathsBlock.hasChangesInDialog() || this.fBuildPathsBlock.isClassfileMissing() || this.fBuildPathsBlock.hasChangesInSuper()) {
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
                        BuildPathsPropertyPage.this.fBuildPathsBlock.configureJavaProject(monitor);
                    }
                };
                WorkbenchRunnableAdapter op = new WorkbenchRunnableAdapter(runnable);
                if (this.fBlockOnApply) {
                    try {
                        new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)op);
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, this.getShell(), PreferencesMessages.BuildPathsPropertyPage_error_title, PreferencesMessages.BuildPathsPropertyPage_error_message);
                        return false;
                    }
                    catch (InterruptedException interruptedException) {
                        return false;
                    }
                } else {
                    op.runAsUserJob(PreferencesMessages.BuildPathsPropertyPage_job_title, null);
                }
            }
        }
        return true;
    }

    @Override
    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Object pageIndex;
            Object entryToAdd;
            Map map = (Map)data;
            Object selectedLibrary = map.get(DATA_REVEAL_ENTRY);
            if (selectedLibrary instanceof IIncludePathEntry) {
                String attributeKey;
                IIncludePathEntry entry = (IIncludePathEntry)selectedLibrary;
                Object attr = map.get(DATA_REVEAL_ATTRIBUTE_KEY);
                String string = attributeKey = attr instanceof String ? (String)attr : null;
                if (this.fBuildPathsBlock != null) {
                    this.fBuildPathsBlock.setElementToReveal(entry, attributeKey);
                }
            }
            if ((entryToAdd = map.get(DATA_ADD_ENTRY)) instanceof IIncludePathEntry && this.fBuildPathsBlock != null) {
                this.fBuildPathsBlock.addElement((IIncludePathEntry)entryToAdd);
            }
            if ((pageIndex = map.get("pageIndex")) instanceof Integer) {
                this.fBuildPathsBlock.showPage((Integer)pageIndex);
            }
            this.fBlockOnApply = Boolean.TRUE.equals(map.get(DATA_BLOCK));
        }
    }
}

