/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ui.contentassist;

import com.google.inject.Inject;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.imports.StaticallyImportedMemberProvider;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.ui.contentassist.AbstractXtypeProposalProvider;
import org.eclipse.xtext.xtype.XImportDeclaration;

public class XtypeProposalProvider
extends AbstractXtypeProposalProvider {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private StaticallyImportedMemberProvider staticallyImportedMemberProvider;

    @Override
    public void completeXImportDeclaration_MemberName(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (model instanceof XImportDeclaration) {
            XImportDeclaration importDeclaration = (XImportDeclaration)model;
            for (JvmFeature feature : this.staticallyImportedMemberProvider.findAllFeatures(importDeclaration)) {
                Image image = this.getImage((EObject)feature);
                LightweightTypeReferenceFactory typeConverter = this.getTypeConverter(context.getResource());
                StyledString displayString = this.getStyledDisplayString(feature, false, 0, feature.getQualifiedName(), feature.getSimpleName(), typeConverter);
                acceptor.accept(this.createCompletionProposal(feature.getSimpleName(), displayString, image, context));
            }
        }
    }

    protected StyledString getStyledDisplayString(JvmFeature feature, boolean withParents, int insignificantParameters, String qualifiedNameAsString, String shortName, LightweightTypeReferenceFactory converter) {
        StyledString result = new StyledString(shortName);
        if (feature instanceof JvmOperation) {
            JvmTypeReference returnType;
            JvmOperation operation = (JvmOperation)feature;
            if (withParents) {
                result.append('(');
                this.appendParameters(result, (JvmExecutable)feature, insignificantParameters, converter);
                result.append(')');
            }
            if ((returnType = operation.getReturnType()) != null && returnType.getSimpleName() != null) {
                result.append(" : ");
                result.append(converter.toLightweightReference(returnType).getHumanReadableName());
            }
            result.append(" - ", StyledString.QUALIFIER_STYLER);
            result.append(converter.toPlainTypeReference((JvmType)feature.getDeclaringType()).getHumanReadableName(), StyledString.QUALIFIER_STYLER);
            if (!withParents) {
                result.append(".", StyledString.QUALIFIER_STYLER);
                result.append(feature.getSimpleName(), StyledString.QUALIFIER_STYLER);
                result.append("()", StyledString.QUALIFIER_STYLER);
            }
        } else if (feature instanceof JvmField) {
            String fieldType;
            JvmField field = (JvmField)feature;
            result.append(" : ");
            if (field.getType() != null && (fieldType = converter.toLightweightReference(field.getType()).getHumanReadableName()) != null) {
                result.append(fieldType);
            }
            result.append(" - ", StyledString.QUALIFIER_STYLER);
            result.append(converter.toPlainTypeReference((JvmType)feature.getDeclaringType()).getHumanReadableName(), StyledString.QUALIFIER_STYLER);
        } else if (feature instanceof JvmConstructor && withParents) {
            result.append('(');
            this.appendParameters(result, (JvmExecutable)feature, insignificantParameters, converter);
            result.append(')');
        }
        return result;
    }

    protected void appendParameters(StyledString result, JvmExecutable executable, int insignificantParameters, LightweightTypeReferenceFactory ownedConverter) {
        EList declaredParameters = executable.getParameters();
        List relevantParameters = declaredParameters.subList(Math.min(insignificantParameters, declaredParameters.size()), declaredParameters.size());
        int i = 0;
        while (i < relevantParameters.size()) {
            String simpleName;
            JvmFormalParameter parameter = (JvmFormalParameter)relevantParameters.get(i);
            if (i != 0) {
                result.append(", ");
            }
            if (i == relevantParameters.size() - 1 && executable.isVarArgs() && parameter.getParameterType() instanceof JvmGenericArrayTypeReference) {
                JvmGenericArrayTypeReference parameterType = (JvmGenericArrayTypeReference)parameter.getParameterType();
                result.append(ownedConverter.toLightweightReference(parameterType.getComponentType()).getHumanReadableName());
                result.append("...");
            } else if (parameter.getParameterType() != null && (simpleName = ownedConverter.toLightweightReference(parameter.getParameterType()).getHumanReadableName()) != null) {
                result.append(simpleName);
            }
            result.append(' ');
            result.append(Strings.notNull((Object)parameter.getName()));
            ++i;
        }
    }

    protected LightweightTypeReferenceFactory getTypeConverter(XtextResource context) {
        return new LightweightTypeReferenceFactory((ITypeReferenceOwner)new StandardTypeReferenceOwner(this.services, (Resource)context)){

            public LightweightTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                LightweightTypeReference result = super.doVisitParameterizedTypeReference(reference);
                if (result.isFunctionType()) {
                    FunctionTypeReference functionTypeReference = result.tryConvertToFunctionTypeReference(false);
                    return functionTypeReference;
                }
                return result;
            }
        };
    }
}

