/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.validation;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Arrays;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmEnumerationLiteral;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XStringLiteral;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XTypeLiteral;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.util.XExpressionHelper;
import org.eclipse.xtext.xbase.validation.NotResolvedFeatureException;

public class ConstantExpressionValidator {
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private Primitives primitives;
    @Inject
    private XExpressionHelper xExpressionHelper;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;

    protected boolean _isConstant(XExpression expression) {
        return false;
    }

    protected boolean _isConstant(XStringLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XTypeLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XNumberLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XBooleanLiteral expression) {
        return true;
    }

    protected boolean _isConstant(XCastedExpression expression) {
        return this.primitives.isPrimitive(expression.getType()) || this.typeReferences.is(expression.getType(), String.class);
    }

    protected boolean _isConstant(XAbstractFeatureCall expression) {
        JvmIdentifiableElement feature = expression.getFeature();
        if (feature instanceof JvmEnumerationLiteral) {
            return true;
        }
        if (feature instanceof JvmField) {
            boolean potentiallyConstant;
            JvmField jvmField = (JvmField)feature;
            if (jvmField.isSetConstant()) {
                return jvmField.isConstant();
            }
            boolean bl = potentiallyConstant = jvmField.isStatic() && jvmField.isFinal();
            if (potentiallyConstant) {
                if (jvmField.eResource() instanceof TypeResource) {
                    return true;
                }
                return this.isConstantExpression(this.logicalContainerProvider.getAssociatedExpression(feature));
            }
            return false;
        }
        if (feature instanceof JvmOperation) {
            JvmAnnotationReference annotationReference = this.xExpressionHelper.findInlineAnnotation(expression);
            if (annotationReference == null) {
                return false;
            }
            if (IterableExtensions.exists((Iterable)Iterables.filter((Iterable)annotationReference.getValues(), JvmBooleanAnnotationValue.class), it -> {
                if ("constantExpression".equals(it.getValueName()) && ((Boolean)Iterables.getFirst((Iterable)it.getValues(), null)).booleanValue()) {
                    return true;
                }
                return false;
            })) {
                boolean receiverConstant = false;
                receiverConstant = expression.getActualReceiver() == null ? true : this.isConstant(expression.getActualReceiver());
                return receiverConstant && IterableExtensions.forall(expression.getActualArguments(), it -> this.isConstant((XExpression)it));
            }
        } else {
            if (feature instanceof XVariableDeclaration) {
                XVariableDeclaration variableDeclaration = (XVariableDeclaration)feature;
                return !variableDeclaration.isWriteable() && this.isConstantExpression(variableDeclaration.getRight());
            }
            if (feature instanceof XSwitchExpression) {
                return this.isConstantExpression(((XSwitchExpression)feature).getSwitch());
            }
            if (feature instanceof EObject && feature.eIsProxy()) {
                throw new NotResolvedFeatureException();
            }
        }
        return false;
    }

    protected boolean _isConstantExpression(Void it) {
        return false;
    }

    protected boolean _isConstantExpression(XExpression it) {
        return this.isConstant(it);
    }

    protected boolean _isConstantExpression(XAbstractFeatureCall it) {
        if (it.getFeature() instanceof JvmEnumerationLiteral) {
            return false;
        }
        return this.isConstant(it);
    }

    public boolean isConstant(XExpression expression) {
        if (expression instanceof XAbstractFeatureCall) {
            return this._isConstant((XAbstractFeatureCall)expression);
        }
        if (expression instanceof XBooleanLiteral) {
            return this._isConstant((XBooleanLiteral)expression);
        }
        if (expression instanceof XCastedExpression) {
            return this._isConstant((XCastedExpression)expression);
        }
        if (expression instanceof XNumberLiteral) {
            return this._isConstant((XNumberLiteral)expression);
        }
        if (expression instanceof XStringLiteral) {
            return this._isConstant((XStringLiteral)expression);
        }
        if (expression instanceof XTypeLiteral) {
            return this._isConstant((XTypeLiteral)expression);
        }
        if (expression != null) {
            return this._isConstant(expression);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression).toString());
    }

    public boolean isConstantExpression(XExpression it) {
        if (it instanceof XAbstractFeatureCall) {
            return this._isConstantExpression((XAbstractFeatureCall)it);
        }
        if (it != null) {
            return this._isConstantExpression(it);
        }
        return this._isConstantExpression((Void)null);
    }
}

