/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.parser;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.impl.AbstractNode;
import org.eclipse.xtext.nodemodel.impl.CompositeNode;
import org.eclipse.xtext.parser.IParseResult;

public abstract class AbstractParseResult
implements IParseResult {
    private EObject rootAstElement;
    private boolean hasErrors;

    protected AbstractParseResult(EObject rootAstElement, boolean hasErrors) {
        this.rootAstElement = rootAstElement;
        this.hasErrors = hasErrors;
    }

    public void setRootASTElement(EObject rootAstElement) {
        this.rootAstElement = rootAstElement;
    }

    @Override
    public EObject getRootASTElement() {
        return this.rootAstElement;
    }

    @Override
    public Iterable<INode> getSyntaxErrors() {
        final ICompositeNode rootNode = this.getRootNode();
        if (rootNode == null || !this.hasSyntaxErrors()) {
            return Collections.emptyList();
        }
        return new Iterable<INode>(){

            @Override
            public Iterator<INode> iterator() {
                UnmodifiableIterator result = Iterators.filter(((CompositeNode)rootNode).basicIterator(), (Predicate)new Predicate<AbstractNode>(){

                    public boolean apply(AbstractNode input) {
                        return input.getSyntaxErrorMessage() != null;
                    }
                });
                return result;
            }
        };
    }

    @Override
    public boolean hasSyntaxErrors() {
        return this.hasErrors;
    }

    public void setHasErrors(boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public abstract void setRootNode(ICompositeNode var1);
}

