/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.zest.core.widgets.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.zest.core.viewers.internal.SharedMessages;
import org.eclipse.zest.core.widgets.GraphNode;

public class NodeSearchDialog {
    private final Shell parent;
    private Shell dialog;
    private final List<? extends GraphNode> nodes;
    private List<GraphNode> searchNodes;
    private int index = 0;
    private boolean isDisposed = false;
    private Text text;
    private Button nextButton;
    private Button prevButton;
    private Button caseSensButton;
    private Button wholeWordButton;

    public NodeSearchDialog(Shell parent, List<? extends GraphNode> nodes) {
        this.nodes = nodes;
        this.parent = parent;
        this.searchNodes = new ArrayList<GraphNode>();
        this.createDialog(parent);
    }

    private void createDialog(Shell parentShell) {
        this.dialog = new Shell(parentShell, 3184);
        this.dialog.setText(SharedMessages.NodeSearchDialog_Title);
        GridLayout layout = new GridLayout(2, false);
        this.dialog.setLayout((Layout)layout);
        Label label = new Label((Composite)this.dialog, 0);
        label.setText(SharedMessages.NodeSearchDialog_Find);
        this.text = new Text((Composite)this.dialog, 2048);
        this.text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                NodeSearchDialog.this.searchForNodes();
            }
        });
        this.text.addModifyListener(e -> {
            if (this.text.getText().isBlank()) {
                this.nextButton.setEnabled(false);
                this.prevButton.setEnabled(false);
            } else {
                this.nextButton.setEnabled(true);
                this.prevButton.setEnabled(true);
            }
        });
        GridData gridData = new GridData(768);
        gridData.minimumWidth = 200;
        this.text.setLayoutData((Object)gridData);
        Label optionsLabel = new Label((Composite)this.dialog, 0);
        optionsLabel.setText(SharedMessages.NodeSearchDialog_Options);
        new Label((Composite)this.dialog, 0);
        this.wholeWordButton = new Button((Composite)this.dialog, 32);
        this.wholeWordButton.addListener(13, e -> this.searchForNodes());
        Label wholeWordLabel = new Label((Composite)this.dialog, 0);
        wholeWordLabel.setText(SharedMessages.NodeSearchDialog_WholeWord);
        this.caseSensButton = new Button((Composite)this.dialog, 32);
        this.caseSensButton.addListener(13, e -> this.searchForNodes());
        Label caseSensitiveLabel = new Label((Composite)this.dialog, 0);
        caseSensitiveLabel.setText(SharedMessages.NodeSearchDialog_CaseSensitive);
        new Label((Composite)this.dialog, 0);
        Composite comp = new Composite((Composite)this.dialog, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        this.nextButton = new Button(comp, 8);
        this.nextButton.setText(SharedMessages.NodeSearchDialog_Next);
        this.nextButton.setEnabled(false);
        this.nextButton.addListener(13, e -> this.changeNode(true));
        this.prevButton = new Button(comp, 8);
        this.prevButton.setText(SharedMessages.NodeSearchDialog_Previous);
        this.prevButton.setEnabled(false);
        this.prevButton.addListener(13, e -> this.changeNode(false));
        new Label((Composite)this.dialog, 0);
        comp = new Composite((Composite)this.dialog, 0);
        comp.setLayout((Layout)new GridLayout(1, false));
        comp.setLayoutData((Object)new GridData(131072, 1024, true, true));
        Button closeButton = new Button(comp, 8);
        closeButton.setText(SharedMessages.NodeSearchDialog_Close);
        closeButton.addListener(13, e -> this.dialog.close());
        this.dialog.addDisposeListener(e -> {
            boolean bl = this.isDisposed = true;
        });
        this.dialog.pack();
    }

    private void searchForNodes() {
        if (this.text.getText().isEmpty()) {
            return;
        }
        boolean searchWhole = this.wholeWordButton.getSelection();
        boolean caseSensitive = this.caseSensButton.getSelection();
        ArrayList<GraphNode> newNodes = new ArrayList<GraphNode>();
        for (GraphNode graphNode : this.nodes) {
            String search;
            String nodeText;
            if (caseSensitive) {
                nodeText = graphNode.getText();
                search = this.text.getText();
            } else {
                nodeText = graphNode.getText().toLowerCase();
                search = this.text.getText().toLowerCase();
            }
            if ((!searchWhole || !nodeText.equals(search)) && (searchWhole || !nodeText.contains(search))) continue;
            newNodes.add(graphNode);
        }
        if (newNodes.size() != this.searchNodes.size() || !this.searchNodes.containsAll(newNodes)) {
            this.index = 0;
            this.searchNodes = newNodes;
        }
    }

    private void changeNode(boolean forward) {
        if (this.searchNodes.isEmpty()) {
            return;
        }
        if (this.index < 0) {
            this.index = this.searchNodes.size() - 1;
        }
        GraphNode node = this.searchNodes.get(this.index % this.searchNodes.size());
        node.getGraphModel().setSelection(new GraphNode[]{node});
        this.index = forward ? this.index + 1 : this.index - 1;
    }

    public void open() {
        if (this.isDisposed) {
            this.isDisposed = false;
            this.createDialog(this.parent);
        }
        this.dialog.open();
    }
}

