/*
 * Decompiled with CFR 0.152.
 */
package org.burningwave.core.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.burningwave.core.assembler.StaticComponentContainer;
import org.burningwave.core.io.ByteBufferInputStream;

public class ByteBufferOutputStream
extends OutputStream {
    private Integer initialCapacity;
    private Integer initialPosition;
    private ByteBuffer buffer;

    public ByteBufferOutputStream(ByteBuffer buffer) {
        this.buffer = buffer;
        this.initialPosition = StaticComponentContainer.BufferHandler.position(buffer);
        this.initialCapacity = StaticComponentContainer.BufferHandler.capacity(buffer);
    }

    public ByteBufferOutputStream(int initialCapacity) {
        this(StaticComponentContainer.BufferHandler.allocate(initialCapacity));
    }

    @Override
    public void write(int b) {
        this.buffer = StaticComponentContainer.BufferHandler.ensureRemaining(this.buffer, 1, this.initialPosition);
        this.buffer.put((byte)b);
    }

    @Override
    public void write(byte[] bytes, int off, int len) {
        this.buffer = StaticComponentContainer.BufferHandler.ensureRemaining(this.buffer, len, this.initialPosition);
        this.buffer.put(bytes, off, len);
    }

    public void write(ByteBuffer sourceBuffer) {
        this.buffer = StaticComponentContainer.BufferHandler.ensureRemaining(this.buffer, StaticComponentContainer.BufferHandler.remaining(sourceBuffer), this.initialPosition);
        this.buffer.put(sourceBuffer);
    }

    public int position() {
        return StaticComponentContainer.BufferHandler.position(this.buffer);
    }

    public int remaining() {
        return StaticComponentContainer.BufferHandler.remaining(this.buffer);
    }

    public int limit() {
        return StaticComponentContainer.BufferHandler.limit(this.buffer);
    }

    public void position(int position) {
        this.buffer = StaticComponentContainer.BufferHandler.ensureRemaining(this.buffer, position - StaticComponentContainer.BufferHandler.position(this.buffer), this.initialPosition);
        StaticComponentContainer.BufferHandler.position(this.buffer, position);
    }

    public int initialCapacity() {
        return this.initialCapacity;
    }

    InputStream toBufferedInputStream() {
        return new ByteBufferInputStream(this.buffer);
    }

    public ByteBuffer toByteBuffer() {
        return StaticComponentContainer.BufferHandler.shareContent(this.buffer);
    }

    public byte[] toByteArray() {
        return StaticComponentContainer.BufferHandler.toByteArray(this.toByteBuffer());
    }

    @Override
    public void close() {
        this.initialCapacity = null;
        this.initialPosition = null;
        this.buffer = null;
    }
}

