/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.clangd.internal.config;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.cdt.lsp.clangd.ClangdConfiguration;
import org.eclipse.cdt.lsp.clangd.ClangdFallbackFlags;
import org.eclipse.cdt.lsp.clangd.ClangdOptions;
import org.eclipse.cdt.lsp.clangd.IClangdCommandLineValidator;
import org.eclipse.cdt.lsp.editor.EditorConfiguration;
import org.eclipse.cdt.lsp.editor.LanguageServerEnable;
import org.eclipse.cdt.lsp.server.ICLanguageServerCommandLineValidator;
import org.eclipse.cdt.lsp.server.ICLanguageServerProvider3;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ServiceCaller;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;

public final class ClangdLanguageServerProvider
implements ICLanguageServerProvider3,
ICLanguageServerCommandLineValidator {
    private final ServiceCaller<IClangdCommandLineValidator> validator = new ServiceCaller(this.getClass(), IClangdCommandLineValidator.class);
    private final ServiceCaller<ClangdConfiguration> configuration = new ServiceCaller(this.getClass(), ClangdConfiguration.class);
    private final ServiceCaller<EditorConfiguration> editorConfiguration = new ServiceCaller(this.getClass(), EditorConfiguration.class);
    private URI cachedRootUri = null;

    public Object getInitializationOptions(URI rootUri) {
        ArrayList result = new ArrayList();
        ServiceCaller.callOnce(this.getClass(), ClangdFallbackFlags.class, f -> {
            boolean bl = result.add(f.getFallbackFlagsFromInitialUri(rootUri));
        });
        return result.stream().filter(Objects::nonNull).findFirst().orElse(null);
    }

    public List<String> getCommands(URI rootUri) {
        this.cachedRootUri = rootUri;
        ArrayList<String> result = new ArrayList<String>();
        this.configuration.call(c -> {
            boolean bl = result.addAll(c.commands(rootUri).stream().map(ClangdLanguageServerProvider::resolveVariables).collect(Collectors.toList()));
        });
        return result;
    }

    private static String resolveVariables(String cmd) {
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(cmd);
        }
        catch (CoreException e) {
            return cmd;
        }
    }

    public boolean isEnabledFor(IProject project) {
        boolean[] enabled = new boolean[1];
        this.editorConfiguration.call(c -> {
            boolean bl = ((LanguageServerEnable)c.options((Object)project)).isEnabledFor(project);
        });
        return enabled[0];
    }

    public boolean logToConsole() {
        boolean[] enabled = new boolean[1];
        this.configuration.call(c -> {
            boolean bl;
            ClangdOptions clangdOptions = c.options(null);
            if (clangdOptions instanceof ClangdOptions) {
                ClangdOptions copt = clangdOptions;
                bl = copt.logToConsole();
            } else {
                bl = false;
            }
            boolean bl2 = blArray[0] = bl;
        });
        return enabled[0];
    }

    public IStatus validateCommandLineOptions() {
        IStatus[] status = new IStatus[]{Status.OK_STATUS};
        if (this.isCommandLineValidationEnabled()) {
            List<String> cmd = this.getCommands(this.cachedRootUri);
            this.validator.call(v -> {
                IStatus iStatus = v.validateCommandLineOptions(cmd);
            });
        }
        return status[0];
    }

    private boolean isCommandLineValidationEnabled() {
        boolean[] enabled = new boolean[1];
        this.configuration.call(c -> {
            boolean bl;
            ClangdOptions clangdOptions = c.options(null);
            if (clangdOptions instanceof ClangdOptions) {
                ClangdOptions copt = clangdOptions;
                bl = copt.validateClangdOptions();
            } else {
                bl = false;
            }
            boolean bl2 = blArray[0] = bl;
        });
        return enabled[0];
    }
}

