/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.common.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDODataOutput;
import org.eclipse.emf.cdo.internal.common.model.CDOTypeImpl;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.factory.Factory;
import org.eclipse.net4j.util.factory.ProductCreationException;

public interface CDOType {
    public static final CDOType OBJECT = CDOTypeImpl.OBJECT;
    public static final CDOType BOOLEAN = CDOTypeImpl.BOOLEAN;
    public static final CDOType BOOLEAN_OBJECT = CDOTypeImpl.BOOLEAN_OBJECT;
    public static final CDOType BYTE = CDOTypeImpl.BYTE;
    public static final CDOType BYTE_OBJECT = CDOTypeImpl.BYTE_OBJECT;
    public static final CDOType CHAR = CDOTypeImpl.CHAR;
    public static final CDOType CHARACTER_OBJECT = CDOTypeImpl.CHARACTER_OBJECT;
    public static final CDOType DATE = CDOTypeImpl.DATE;
    public static final CDOType DOUBLE = CDOTypeImpl.DOUBLE;
    public static final CDOType DOUBLE_OBJECT = CDOTypeImpl.DOUBLE_OBJECT;
    public static final CDOType FLOAT = CDOTypeImpl.FLOAT;
    public static final CDOType FLOAT_OBJECT = CDOTypeImpl.FLOAT_OBJECT;
    public static final CDOType INT = CDOTypeImpl.INT;
    public static final CDOType INTEGER_OBJECT = CDOTypeImpl.INTEGER_OBJECT;
    public static final CDOType LONG = CDOTypeImpl.LONG;
    public static final CDOType LONG_OBJECT = CDOTypeImpl.LONG_OBJECT;
    public static final CDOType SHORT = CDOTypeImpl.SHORT;
    public static final CDOType SHORT_OBJECT = CDOTypeImpl.SHORT_OBJECT;
    public static final CDOType STRING = CDOTypeImpl.STRING;
    public static final CDOType BYTE_ARRAY = CDOTypeImpl.BYTE_ARRAY;
    public static final CDOType OBJECT_ARRAY = CDOTypeImpl.OBJECT_ARRAY;
    public static final CDOType MAP = CDOTypeImpl.MAP;
    public static final CDOType SET = CDOTypeImpl.SET;
    public static final CDOType LIST = CDOTypeImpl.LIST;
    public static final CDOType BIG_DECIMAL = CDOTypeImpl.BIG_DECIMAL;
    public static final CDOType BIG_INTEGER = CDOTypeImpl.BIG_INTEGER;
    public static final CDOType ENUM_ORDINAL = CDOTypeImpl.ENUM_ORDINAL;
    public static final CDOType ENUM_LITERAL = CDOTypeImpl.ENUM_LITERAL;
    public static final CDOType BLOB = CDOTypeImpl.BLOB;
    public static final CDOType CLOB = CDOTypeImpl.CLOB;
    public static final CDOType JAVA_CLASS = CDOTypeImpl.JAVA_CLASS;
    public static final CDOType JAVA_OBJECT = CDOTypeImpl.JAVA_OBJECT;
    public static final CDOType CUSTOM = CDOTypeImpl.CUSTOM;
    @Deprecated
    public static final CDOType FEATURE_MAP_ENTRY = null;
    public static final CDOType EXCEPTION = CDOTypeImpl.EXCEPTION;
    public static final CDOType HANDLER = CDOTypeImpl.HANDLER;

    public String getName();

    public byte getTypeID();

    public boolean canBeNull();

    public Object getDefaultValue();

    public Object copyValue(Object var1);

    public Object adjustReferences(CDOReferenceAdjuster var1, Object var2, EStructuralFeature var3, int var4);

    public Object readValue(CDODataInput var1) throws IOException;

    public void writeValue(CDODataOutput var1, Object var2) throws IOException;

    public Object convertToEMF(EClassifier var1, Object var2);

    public Object convertToCDO(EClassifier var1, Object var2);

    public static abstract class Handler {
        public static final int DEFAULT_PRIORITY = 100;
        private final String type;

        public Handler(String type) {
            this.type = type;
        }

        public final String getType() {
            return this.type;
        }

        public int getPriority() {
            return 100;
        }

        public abstract boolean canHandle(Object var1);

        public abstract void writeValue(CDODataOutput var1, Object var2) throws IOException;

        public abstract Object readValue(CDODataInput var1) throws IOException;

        public static abstract class Factory
        extends org.eclipse.net4j.util.factory.Factory {
            public static final String PRODUCT_GROUP = "org.eclipse.emf.cdo.common.model.typeHandlers";

            public Factory(String type) {
                super(PRODUCT_GROUP, type);
            }

            public abstract Handler create(String var1) throws ProductCreationException;
        }

        public static final class Registry {
            public static final Registry INSTANCE = new Registry();
            private final Map<String, Handler> handlersByType = new HashMap<String, Handler>();
            private final List<Handler> handlers = new ArrayList<Handler>();

            private Registry() {
                IPluginContainer.INSTANCE.forEachElement("org.eclipse.emf.cdo.common.model.typeHandlers", Handler.class, this::registerHandler);
                this.updateHandlers();
            }

            private void updateHandlers() {
                this.handlers.clear();
                this.handlers.addAll(this.handlersByType.values());
                this.handlers.sort(Comparator.comparingInt(Handler::getPriority).reversed());
            }

            private boolean registerHandler(Handler handler) {
                String type = handler.getType();
                Handler existingHandler = this.handlersByType.get(type);
                if (existingHandler == null || handler.getPriority() > existingHandler.getPriority()) {
                    this.handlersByType.put(type, handler);
                    return true;
                }
                return false;
            }

            public void addHandler(Handler handler) {
                if (this.registerHandler(handler)) {
                    this.updateHandlers();
                }
            }

            public Handler getHandlerByType(String type) {
                return this.handlersByType.get(type);
            }

            public Handler getHandlerByValue(Object value) {
                for (Handler handler : this.handlers) {
                    if (!handler.canHandle(value)) continue;
                    return handler;
                }
                return null;
            }
        }
    }
}

