/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer.repositories;

import java.io.File;
import java.util.Properties;
import org.eclipse.emf.cdo.internal.explorer.repositories.CDORepositoryImpl;
import org.eclipse.net4j.util.StringUtil;

public class RemoteCDORepository
extends CDORepositoryImpl {
    public static final String PROP_CONNECTOR_TYPE = "connectorType";
    public static final String PROP_CONNECTOR_DESCRIPTION = "connectorDescription";
    public static final String PROP_AUTHENTICATING = "authenticating";
    private String connectorType;
    private String connectorDescription;
    private boolean authenticating;

    @Override
    public final boolean isRemote() {
        return true;
    }

    @Override
    public final boolean isClone() {
        return false;
    }

    @Override
    public final boolean isLocal() {
        return false;
    }

    @Override
    public final String getConnectorType() {
        return this.connectorType;
    }

    @Override
    public final String getConnectorDescription() {
        return this.connectorDescription;
    }

    @Override
    public final boolean isAuthenticating() {
        return this.authenticating;
    }

    @Override
    public String getURI() {
        return String.valueOf(this.connectorType) + "://" + this.connectorDescription + "/" + this.getName();
    }

    @Override
    protected void init(File folder, String type, Properties properties) {
        super.init(folder, type, properties);
        this.connectorType = properties.getProperty(PROP_CONNECTOR_TYPE);
        this.connectorDescription = properties.getProperty(PROP_CONNECTOR_DESCRIPTION);
        this.authenticating = Boolean.parseBoolean(properties.getProperty(PROP_AUTHENTICATING, StringUtil.FALSE));
    }

    @Override
    protected void collectProperties(Properties properties) {
        super.collectProperties(properties);
        properties.setProperty(PROP_CONNECTOR_TYPE, this.connectorType);
        properties.setProperty(PROP_CONNECTOR_DESCRIPTION, this.connectorDescription);
        properties.setProperty(PROP_AUTHENTICATING, Boolean.toString(this.authenticating));
    }
}

