/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreEditPlugin;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class EModelElementItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    protected List<EStructuralFeature> nonGenericChildrenFeatures;

    public EModelElementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        return this.itemPropertyDescriptors;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        List<EStructuralFeature> childrenFeatures = this.getChildrenFeatures();
        if (childrenFeatures == null) {
            if (this.isShowGenerics()) {
                this.childrenFeatures = new ArrayList<EStructuralFeature>();
                childrenFeatures = this.childrenFeatures;
            } else {
                this.nonGenericChildrenFeatures = new ArrayList<EStructuralFeature>();
                childrenFeatures = this.nonGenericChildrenFeatures;
            }
            childrenFeatures.add((EStructuralFeature)EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS);
        }
        return childrenFeatures;
    }

    protected boolean isShowGenerics() {
        return !(this.adapterFactory instanceof EcoreItemProviderAdapterFactory) || ((EcoreItemProviderAdapterFactory)this.adapterFactory).isShowGenerics();
    }

    protected List<EStructuralFeature> getChildrenFeatures() {
        return this.isShowGenerics() ? this.childrenFeatures : this.nonGenericChildrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public String getText(Object object) {
        return this.getString("_UI_EModelElement_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(EModelElement.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        EModelElement eModelElement = (EModelElement)object;
        ArrayList sources = new ArrayList();
        sources.add(null);
        if (eModelElement.eClass().getEPackage() == EcorePackage.eINSTANCE) {
            EList eAnnotations = eModelElement.getEAnnotations();
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eModelElement.eSetDeliver(false);
            try {
                eAnnotations.add((Object)eAnnotation);
                IItemPropertyDescriptor propertyDescriptor = new AdapterFactoryItemDelegator(this.getRootAdapterFactory()).getPropertyDescriptor((Object)eAnnotation, (Object)EcorePackage.Literals.EANNOTATION__SOURCE);
                Collection choiceOfValues = propertyDescriptor.getChoiceOfValues((Object)eAnnotation);
                sources.addAll(choiceOfValues);
            }
            finally {
                eAnnotations.remove((Object)eAnnotation);
                eModelElement.eSetDeliver(true);
                eAnnotation.eAdapters().clear();
            }
        }
        for (String source : sources) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource(source);
            newChildDescriptors.add(this.createChildParameter(EcorePackage.Literals.EMODEL_ELEMENT__EANNOTATIONS, eAnnotation));
        }
    }

    public ResourceLocator getResourceLocator() {
        return EcoreEditPlugin.INSTANCE;
    }

    public String stripToNull(String value) {
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    protected static class ItemPropertyDescriptorWithUniqueChoiceOfValueLabels
    extends ItemPropertyDescriptor {
        protected Map<Object, String> uniqueNameMap;

        public ItemPropertyDescriptorWithUniqueChoiceOfValueLabels(AdapterFactory adapterFactory, ResourceLocator resourceLocator, String displayName, String description, EStructuralFeature feature, boolean isSettable, boolean multiLine, boolean sortChoices, Object staticImage, String category, String[] filterFlags) {
            super(adapterFactory, resourceLocator, displayName, description, feature, isSettable, multiLine, sortChoices, staticImage, category, filterFlags);
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            if (this.uniqueNameMap != null) {
                final Map<Object, String> uniqueNameMap = this.uniqueNameMap;
                this.uniqueNameMap = null;
                return new ItemPropertyDescriptor.ItemDelegator(this, this.adapterFactory, this.resourceLocator){

                    public String getText(Object object) {
                        String result = (String)uniqueNameMap.get(object);
                        return result != null ? result : super.getText(object);
                    }
                };
            }
            return super.getLabelProvider(object);
        }

        protected Map<Object, String> computeUniqueLabels(Object object, Collection<?> items) {
            Resource resource = ((EObject)object).eResource();
            URI base = resource == null ? URI.createURI((String)"") : resource.getURI();
            HashSet<String> conflictingLabels = new HashSet<String>();
            HashMap labelToObjectMap = new HashMap();
            IItemLabelProvider labelProvider = this.getLabelProvider(object);
            for (Object item : items) {
                String label = labelProvider.getText(item);
                if ("".equals(label)) {
                    if (item == null) continue;
                    labelToObjectMap.put("- " + this.getURI((EObject)item, base), item);
                    continue;
                }
                if (conflictingLabels.contains(label)) {
                    labelToObjectMap.put(String.valueOf(label) + " - " + this.getURI((EObject)item, base), item);
                    continue;
                }
                Object collision = labelToObjectMap.put(label, item);
                if (collision == null) continue;
                conflictingLabels.add(label);
                labelToObjectMap.remove(label);
                labelToObjectMap.put(String.valueOf(label) + " - " + this.getURI((EObject)item, base), item);
                labelToObjectMap.put(String.valueOf(label) + " - " + this.getURI((EObject)collision, base), collision);
            }
            HashMap<Object, String> result = new HashMap<Object, String>();
            for (Map.Entry entry : labelToObjectMap.entrySet()) {
                result.put(entry.getValue(), (String)entry.getKey());
            }
            return result;
        }

        private URI getURI(EObject eObject, URI base) {
            URI uri = EcoreUtil.getURI((EObject)eObject);
            return uri.deresolve(base);
        }

        public Collection<?> getChoiceOfValues(Object object) {
            LinkedList result = super.getChoiceOfValues(object);
            if (this.feature instanceof EReference && object instanceof EObject) {
                ResourceSet resourceSet;
                LinkedList eObjects = new LinkedList(result);
                Resource resource = ((EObject)object).eResource();
                if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
                    HashSet visited = new HashSet(eObjects);
                    EPackage.Registry packageRegistry = resourceSet.getPackageRegistry();
                    for (String nsURI : packageRegistry.keySet()) {
                        ItemPropertyDescriptorWithUniqueChoiceOfValueLabels.collectReachableObjectsOfType(visited, eObjects, (EObject)packageRegistry.getEPackage(nsURI), (EClassifier)this.feature.getEType());
                    }
                }
                result = eObjects;
            }
            return result;
        }
    }
}

