/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.handlers;

import java.util.Collections;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.mvc.fx.handlers.AbstractHandler;
import org.eclipse.gef.mvc.fx.handlers.IOnStrokeHandler;
import org.eclipse.gef.mvc.fx.models.SelectionModel;
import org.eclipse.gef.mvc.fx.operations.ChangeSelectionOperation;
import org.eclipse.gef.mvc.fx.operations.DeselectOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.SelectOperation;
import org.eclipse.gef.mvc.fx.parts.IContentPart;
import org.eclipse.gef.mvc.fx.parts.IRootPart;
import org.eclipse.gef.mvc.fx.parts.IVisualPart;
import org.eclipse.gef.mvc.fx.viewer.IViewer;

public class SelectFocusedOnTypeHandler
extends AbstractHandler
implements IOnStrokeHandler {
    @Override
    public void abortPress() {
    }

    @Override
    public void finalRelease(KeyEvent event) {
    }

    @Override
    public void initialPress(KeyEvent event) {
        if (this.isRegistered(event.getTarget()) && !this.isRegisteredForHost(event.getTarget())) {
            return;
        }
        if (!this.isSelect(event)) {
            return;
        }
        IVisualPart<? extends Node> host = this.getHost();
        IViewer viewer = host.getRoot().getViewer();
        SelectionModel selectionModel = (SelectionModel)((Object)viewer.getAdapter(SelectionModel.class));
        AbstractOperation op = null;
        if (host instanceof IRootPart) {
            op = new DeselectOperation(viewer, (List<? extends IContentPart<? extends Node>>)selectionModel.getSelectionUnmodifiable());
        } else if (host instanceof IContentPart) {
            IContentPart contentPart = (IContentPart)host;
            op = event.isControlDown() ? (selectionModel.isSelected(contentPart) ? new DeselectOperation(viewer, Collections.singletonList(contentPart)) : new SelectOperation(viewer, Collections.singletonList(contentPart))) : new ChangeSelectionOperation(viewer, Collections.singletonList(contentPart));
        }
        if (op != null) {
            try {
                viewer.getDomain().execute((ITransactionalOperation)op, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected boolean isSelect(KeyEvent event) {
        return KeyCode.SPACE.equals((Object)event.getCode());
    }

    @Override
    public void press(KeyEvent event) {
    }

    @Override
    public void release(KeyEvent event) {
    }
}

