/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jpt.common.core.internal.utility.jdt.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceDatabaseGeneratorAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.SequenceGeneratorAnnotation;

public abstract class SourceSequenceGeneratorAnnotation
extends SourceDatabaseGeneratorAnnotation
implements SequenceGeneratorAnnotation {
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter(ANNOTATION_NAME);
    private static final DeclarationAnnotationElementAdapter<String> NAME_ADAPTER = SourceSequenceGeneratorAnnotation.buildAdapter("name");
    private static final DeclarationAnnotationElementAdapter<Integer> INITIAL_VALUE_ADAPTER = SourceSequenceGeneratorAnnotation.buildIntegerAdapter("initialValue");
    private static final DeclarationAnnotationElementAdapter<Integer> ALLOCATION_SIZE_ADAPTER = SourceSequenceGeneratorAnnotation.buildIntegerAdapter("allocationSize");
    private static final DeclarationAnnotationElementAdapter<String> SEQUENCE_NAME_ADAPTER = SourceSequenceGeneratorAnnotation.buildAdapter("sequenceName");
    private final AnnotationElementAdapter<String> sequenceNameAdapter = this.buildAdapter(SEQUENCE_NAME_ADAPTER);
    private String sequenceName;
    private TextRange sequenceNameTextRange;

    protected SourceSequenceGeneratorAnnotation(JavaResourceModel parent, AnnotatedElement element) {
        super(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public String getAnnotationName() {
        return ANNOTATION_NAME;
    }

    @Override
    public void initialize(Annotation astAnnotation) {
        super.initialize(astAnnotation);
        this.sequenceName = this.buildSequenceName(astAnnotation);
        this.sequenceNameTextRange = this.buildSequenceNameTextRange(astAnnotation);
    }

    @Override
    public void synchronizeWith(Annotation astAnnotation) {
        super.synchronizeWith(astAnnotation);
        this.syncSequenceName(this.buildSequenceName(astAnnotation));
        this.sequenceNameTextRange = this.buildSequenceNameTextRange(astAnnotation);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.sequenceName == null;
    }

    @Override
    protected DeclarationAnnotationElementAdapter<String> getNameAdapter() {
        return NAME_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getInitialValueAdapter() {
        return INITIAL_VALUE_ADAPTER;
    }

    @Override
    DeclarationAnnotationElementAdapter<Integer> getAllocationSizeAdapter() {
        return ALLOCATION_SIZE_ADAPTER;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    @Override
    public void setSequenceName(String sequenceName) {
        if (ObjectTools.notEquals((Object)this.sequenceName, (Object)sequenceName)) {
            this.sequenceName = sequenceName;
            this.sequenceNameAdapter.setValue((Object)sequenceName);
        }
    }

    public void syncSequenceName(String astSequenceName) {
        String old = this.sequenceName;
        this.sequenceName = astSequenceName;
        this.firePropertyChanged("sequenceName", old, astSequenceName);
    }

    private String buildSequenceName(Annotation astAnnotation) {
        return (String)this.sequenceNameAdapter.getValue(astAnnotation);
    }

    @Override
    public TextRange getSequenceNameTextRange() {
        return this.sequenceNameTextRange;
    }

    private TextRange buildSequenceNameTextRange(Annotation astAnnotation) {
        return this.getElementTextRange(SEQUENCE_NAME_ADAPTER, astAnnotation);
    }

    @Override
    public boolean sequenceNameTouches(int pos) {
        return this.textRangeTouches(this.sequenceNameTextRange, pos);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildAdapter(String elementName) {
        return SourceSequenceGeneratorAnnotation.buildAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }

    protected static DeclarationAnnotationElementAdapter<Integer> buildIntegerAdapter(String elementName) {
        return SourceSequenceGeneratorAnnotation.buildIntegerAdapter(DECLARATION_ANNOTATION_ADAPTER, elementName);
    }
}

