/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IAddBendpointFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddBendpointContext;
import org.eclipse.graphiti.features.context.IAddConnectionContext;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddBendpointContext;
import org.eclipse.graphiti.features.impl.AbstractAddFeature;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.FreeFormConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.JPAEditorImageCreator;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IsARelation;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.Wrp;
import org.eclipse.swt.graphics.Point;

public class AddInheritedEntityFeature
extends AbstractAddFeature {
    private static final double START_COEFFICIENT = 0.1;
    private IJPAEditorImageCreator imageCreator;

    public AddInheritedEntityFeature(IFeatureProvider fp) {
        this(fp, new JPAEditorImageCreator());
    }

    public AddInheritedEntityFeature(IFeatureProvider fp, IJPAEditorImageCreator imageCreator) {
        super(fp);
        this.imageCreator = imageCreator;
    }

    public boolean canAdd(IAddContext context) {
        return true;
    }

    public PictogramElement add(IAddContext context) {
        final IAddConnectionContext addConContext = (IAddConnectionContext)context;
        final IsARelation relation = (IsARelation)context.getNewObject();
        final Diagram diagram = this.getDiagram();
        final Wrp wrp = new Wrp();
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)diagram);
        RecordingCommand rc = new RecordingCommand(ted){

            protected void doExecute() {
                FreeFormConnection connection = AddInheritedEntityFeature.this.createConnection(addConContext, diagram);
                AddInheritedEntityFeature.this.imageCreator.createIsAConnectionLine(diagram, (Connection)connection);
                AddInheritedEntityFeature.this.getFeatureProvider().putKeyToBusinessObject(relation.getId(), relation);
                AddInheritedEntityFeature.this.link((PictogramElement)connection, relation);
                AddInheritedEntityFeature.this.layoutPictogramElement((PictogramElement)connection);
                wrp.setObj(connection);
            }
        };
        try {
            ted.getCommandStack().execute((Command)rc);
        }
        catch (Exception exception) {}
        return (PictogramElement)wrp.getObj();
    }

    private FreeFormConnection createConnection(IAddConnectionContext addConContext, Diagram diagram) {
        FreeFormConnection connection = this.getFeatureProvider().getPeServiceUtil().createFreeFormConnection(diagram);
        connection.setStart(addConContext.getSourceAnchor());
        connection.setEnd(addConContext.getTargetAnchor());
        connection.setVisible(true);
        connection.setActive(true);
        List<Point> points = JPAEditorUtil.createBendPointList(connection, false);
        int i = 0;
        while (i < points.size()) {
            Point p = points.get(i);
            AddBendpointContext ctx = new AddBendpointContext(connection, p.x, p.y, i);
            IAddBendpointFeature ft = this.getFeatureProvider().getAddBendpointFeature((IAddBendpointContext)ctx);
            ft.addBendpoint((IAddBendpointContext)ctx);
            ++i;
        }
        this.getFeatureProvider().getPeServiceUtil().setPropertyValue((PropertyContainer)connection, "is_is_a_connection", Boolean.TRUE.toString());
        this.addDecorators(connection);
        return connection;
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    private void addDecorators(FreeFormConnection c) {
        double startCoefficient = 0.1;
        double endCoefficient = 1.0 - startCoefficient;
        int len = JPAEditorUtil.calcConnectionLength(c);
        ConnectionDecorator d1 = this.imageCreator.createIsAArrowConnectionDecorator((Connection)c, endCoefficient);
        Graphiti.getGaService().setLocation(d1.getGraphicsAlgorithm(), Math.round(-len / 10), 0);
    }
}

