/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.dom.runtime.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum WebParamKind implements Enumerator
{
    IN(0, "IN", "IN"),
    INOUT(1, "INOUT", "INOUT"),
    OUT(2, "OUT", "OUT");

    public static final int IN_VALUE = 0;
    public static final int INOUT_VALUE = 1;
    public static final int OUT_VALUE = 2;
    private static final WebParamKind[] VALUES_ARRAY;
    public static final List<WebParamKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new WebParamKind[]{IN, INOUT, OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static WebParamKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WebParamKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WebParamKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            WebParamKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static WebParamKind get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return INOUT;
            }
            case 2: {
                return OUT;
            }
        }
        return null;
    }

    private WebParamKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

