/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.m2m.atl.common.ATLLogger;

public class AtlNbCharFile {
    private static final int ANTLR_TAB_WIDTH = 1;
    private List<Line> lines;

    public AtlNbCharFile(InputStream in) {
        this.computePosition(in);
    }

    private void computePosition(InputStream is) {
        this.lines = new ArrayList<Line>();
        try {
            int currentLineCharIndex = 0;
            int currentCharIndex = 0;
            int currentCharInLine = 0;
            int nbCharsSinceLastTab = 0;
            ArrayList<Integer> indexTabs = new ArrayList<Integer>();
            ArrayList<Integer> tabsWidth = new ArrayList<Integer>();
            while (true) {
                int currentChar;
                if ((char)(currentChar = is.read()) == '\n' || currentChar == -1) {
                    this.lines.add(new Line(currentLineCharIndex, indexTabs, tabsWidth));
                    currentLineCharIndex = currentCharIndex;
                    indexTabs = new ArrayList();
                    tabsWidth = new ArrayList();
                    currentCharInLine = -1;
                    nbCharsSinceLastTab = -1;
                    if (currentChar == -1) {
                        break;
                    }
                } else if ((char)currentChar == '\t') {
                    indexTabs.add(new Integer(currentCharInLine));
                    tabsWidth.add(new Integer(1 - nbCharsSinceLastTab % 1));
                    nbCharsSinceLastTab = -1;
                }
                ++currentCharIndex;
                ++currentCharInLine;
                ++nbCharsSinceLastTab;
            }
            this.lines.add(new Line(currentLineCharIndex, indexTabs, tabsWidth));
            is.close();
        }
        catch (IOException e) {
            ATLLogger.log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private int getIndexChar(int lineNumber, int column, int tabWidth) {
        int ret = 0;
        if (lineNumber != 1 || column != 1) {
            int indexOffset = 0;
            if (lineNumber > this.lines.size()) {
                return -1;
            }
            Line line = this.lines.get(lineNumber - 1);
            Iterator<Integer> i = line.indexTabs.iterator();
            while (i.hasNext()) {
                int index = i.next() + indexOffset;
                int actualTabWidth = tabWidth - index % tabWidth;
                if (column <= index) break;
                ret -= actualTabWidth - 1;
                indexOffset += actualTabWidth - 1;
            }
            ret += line.indexFirstChar + column + 1;
            if (lineNumber == 1) {
                --ret;
            }
        }
        return ret;
    }

    public int[] getIndexChar(String sourceLocation) {
        return this.getIndexChar(sourceLocation, 1);
    }

    public int[] getIndexChar(String sourceLocation, int tabWidth) {
        int[] ret = new int[2];
        int currentTabWidth = tabWidth;
        if (currentTabWidth < 0) {
            currentTabWidth = 1;
        }
        String locRegex = "^(-?\\d{1,9}):(-?\\d{1,9})-(-?\\d{1,9}):(-?\\d{1,9})$";
        if (sourceLocation.matches("^(-?\\d{1,9}):(-?\\d{1,9})-(-?\\d{1,9}):(-?\\d{1,9})$")) {
            ret[0] = this.getIndexChar(Integer.parseInt(sourceLocation.replaceFirst("^(-?\\d{1,9}):(-?\\d{1,9})-(-?\\d{1,9}):(-?\\d{1,9})$", "$1")), Integer.parseInt(sourceLocation.replaceFirst("^(-?\\d{1,9}):(-?\\d{1,9})-(-?\\d{1,9}):(-?\\d{1,9})$", "$2")) - 1, currentTabWidth);
            ret[1] = this.getIndexChar(Integer.parseInt(sourceLocation.replaceFirst("^(-?\\d{1,9}):(-?\\d{1,9})-(-?\\d{1,9}):(-?\\d{1,9})$", "$3")), Integer.parseInt(sourceLocation.replaceFirst("^(-?\\d{1,9}):(-?\\d{1,9})-(-?\\d{1,9}):(-?\\d{1,9})$", "$4")) - 1, currentTabWidth);
        } else {
            ret[0] = 0;
            ret[1] = -1;
        }
        return ret;
    }

    public int getIndex(String cursorPosition) {
        int ret = 0;
        String[] starts = cursorPosition.split(":");
        int startLine = Integer.parseInt(starts[0].trim());
        int startColumn = Integer.parseInt(starts[1].trim()) - 1;
        ret = this.getIndexChar(startLine, startColumn, 4);
        return ret;
    }

    class Line {
        int indexFirstChar;
        List<Integer> indexTabs;
        List<Integer> tabsWidth;

        public Line(int indexFirstChar, List<Integer> indexTabs, List<Integer> tabsWidth) {
            this.indexFirstChar = indexFirstChar;
            this.indexTabs = indexTabs;
            this.tabsWidth = tabsWidth;
        }
    }
}

