/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import java.util.Arrays;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.Bytes;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.quantize.Quantize;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.Subjects;
import org.eclipse.mat.snapshot.model.IArray;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.IHeapObjectArgument;
import org.eclipse.mat.snapshot.query.RetainedSizeDerivedData;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="arrays_grouped_by_size")
@Icon(value="/META-INF/icons/array_size.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
@Subjects(value={"byte[]", "boolean[]", "short[]", "char[]", "int[]", "float[]", "long[]", "double[]", "java.lang.Object[]"})
public class ArraysBySizeQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IHeapObjectArgument objects;

    public IResult execute(IProgressListener listener) throws Exception {
        listener.subTask(Messages.ArraysBySizeQuery_ExtractingArraySizes);
        Quantize.Builder builder = Quantize.valueDistribution((Column[])new Column[]{new Column(Messages.ArraysBySizeQuery_ColumnLength, Integer.TYPE).noTotals(), new Column(Messages.ArraysBySizeQuery_SingleInstanceSize, Bytes.class).noTotals()});
        builder.column(Messages.ArraysBySizeQuery_ColumnNumObjects, Quantize.COUNT);
        builder.column(Messages.Column_ShallowHeap, Quantize.SUM_BYTES, Column.SortDirection.DESC);
        builder.addDerivedData(RetainedSizeDerivedData.APPROXIMATE);
        Quantize quantize = builder.build();
        int counter = 0;
        IClass type = null;
        for (int[] objectIds : this.objects) {
            int objectId;
            HashMapIntObject resultMap = null;
            int[] sortedObjs = objectIds;
            int prev = Integer.MIN_VALUE;
            int[] nArray = objectIds;
            int n = objectIds.length;
            int n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (objectId < prev) {
                    sortedObjs = (int[])objectIds.clone();
                    Arrays.sort(sortedObjs);
                    resultMap = new HashMapIntObject();
                    break;
                }
                prev = objectId;
                ++n2;
            }
            nArray = sortedObjs;
            n = sortedObjs.length;
            n2 = 0;
            while (n2 < n) {
                objectId = nArray[n2];
                if (listener.isCanceled()) break;
                if (this.snapshot.isArray(objectId)) {
                    IObject obj;
                    if (counter++ % 1000 == 0 && this.snapshot.getClassOf(objectId).equals(type)) {
                        type = this.snapshot.getClassOf(objectId);
                        listener.subTask(String.valueOf(Messages.ArraysBySizeQuery_ExtractingArraySizes) + "\n" + type.getName());
                    }
                    int len = (obj = this.snapshot.getObject(objectId)) instanceof IArray ? ((IArray)obj).getLength() : 0;
                    long size = this.snapshot.getHeapSize(objectId);
                    if (resultMap != null) {
                        resultMap.put(objectId, (Object)new Result(len, size));
                    } else {
                        quantize.addValue(objectId, new Object[]{len, size, null, size});
                    }
                }
                ++n2;
            }
            if (resultMap != null) {
                nArray = objectIds;
                n = objectIds.length;
                n2 = 0;
                while (n2 < n) {
                    objectId = nArray[n2];
                    if (resultMap.containsKey(objectId)) {
                        Result r = (Result)resultMap.get(objectId);
                        quantize.addValue(objectId, new Object[]{r.len, r.size, null, r.size});
                    }
                    ++n2;
                }
            }
            if (listener.isCanceled()) break;
        }
        return quantize.getResult();
    }

    private static class Result {
        final int len;
        final long size;

        public Result(int len, long size) {
            this.len = len;
            this.size = size;
        }
    }
}

