/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class ArrayCollectionExtractor
implements ICollectionExtractor {
    public static final ICollectionExtractor INSTANCE = new ArrayCollectionExtractor();

    private ArrayCollectionExtractor() {
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        return ExtractionUtils.getNumberOfNotNullArrayElements((IObjectArray)coll);
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return ((IObjectArray)coll).getLength();
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        return ExtractionUtils.referenceArrayToIds(coll.getSnapshot(), this.extractEntries(coll).getReferenceArray());
    }

    @Override
    public boolean hasExtractableArray() {
        return true;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        return (IObjectArray)coll;
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return ExtractionUtils.getNumberOfNotNullArrayElements(this.extractEntries(coll));
    }

    @Override
    public boolean hasFillRatio() {
        return true;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        double numberOfNotNullElements = this.getNumberOfNotNullElements(coll).intValue();
        double capacity = this.getCapacity(coll).intValue();
        if (numberOfNotNullElements == 0.0 && capacity == 0.0) {
            return 1.0;
        }
        return numberOfNotNullElements / capacity;
    }
}

