/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.Field;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.ui.MemoryAnalyserPlugin;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldNode;
import org.eclipse.mat.ui.snapshot.views.inspector.FieldsContentProvider;
import org.eclipse.mat.ui.snapshot.views.inspector.InspectorView;
import org.eclipse.mat.ui.snapshot.views.inspector.NamedReferenceNode;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

class FieldsLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private final InspectorView inspectorView;
    private Font italicFont;
    private Font boldFont;

    public FieldsLabelProvider(InspectorView inspectorView, Font defaultFont) {
        this.inspectorView = inspectorView;
        FontDescriptor fontDescriptor = FontDescriptor.createFrom((Font)defaultFont);
        Display display = inspectorView.getSite().getShell().getDisplay();
        this.italicFont = fontDescriptor.setStyle(2).createFont((Device)display);
        this.boldFont = fontDescriptor.setStyle(1).createFont((Device)display);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 2) {
            return null;
        }
        if (element instanceof FieldsContentProvider.MoreNode) {
            return MemoryAnalyserPlugin.getImage("$nl$/icons/plus.gif");
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof FieldsContentProvider.MoreNode) {
            switch (columnIndex) {
                case 2: {
                    return ((FieldsContentProvider.MoreNode)element).toString();
                }
            }
        } else if (element instanceof FieldNode) {
            Field field = ((FieldNode)element).getField();
            switch (columnIndex) {
                case 0: {
                    return field.getVerboseSignature();
                }
                case 1: {
                    return field.getName();
                }
                case 2: {
                    return String.valueOf(field.getValue());
                }
            }
        } else if (element instanceof NamedReferenceNode) {
            NamedReferenceNode node = (NamedReferenceNode)element;
            switch (columnIndex) {
                case 0: {
                    return "ref";
                }
                case 1: {
                    return node.getName();
                }
                case 2: {
                    return this.getObjectLabel(node.getObjectAddress());
                }
            }
        }
        return null;
    }

    private String getObjectLabel(long objectAddress) {
        try {
            ISnapshot snapshot = this.inspectorView.snapshot;
            if (snapshot != null) {
                ObjectReference ref = new ObjectReference(snapshot, objectAddress);
                IObject object = ref.getObject();
                String text = object.getClassSpecificName();
                if (text == null) {
                    text = object.getTechnicalName();
                }
                return text;
            }
        }
        catch (SnapshotException snapshotException) {
            // empty catch block
        }
        return "0x" + Long.toHexString(objectAddress);
    }

    public Font getFont(Object element, int columnIndex) {
        if (element instanceof NamedReferenceNode && ((NamedReferenceNode)element).isStatic() || element instanceof FieldNode && ((FieldNode)element).isStatic()) {
            return this.italicFont;
        }
        if (element instanceof FieldsContentProvider.MoreNode) {
            return this.boldFont;
        }
        return null;
    }

    public void dispose() {
        this.italicFont.dispose();
        this.boldFont.dispose();
    }
}

