/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import lpg.runtime.ParseErrorCodes;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.ocl.internal.l10n.OCLMessages;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.ProblemHandler;

public abstract class AbstractProblemHandler
implements ProblemHandler,
ParseErrorCodes {
    private AbstractParser parser;
    private int errorReportLineOffset = 0;

    protected AbstractProblemHandler(AbstractParser parser) {
        this.parser = parser;
    }

    protected void addProblem(String message) {
        System.out.println(message);
    }

    @Override
    public void analyzerProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.ANALYZER, problemMessage, processingContext, startOffset, endOffset);
    }

    @Override
    public void beginParse() {
    }

    @Override
    public void endParse() {
    }

    @Override
    public void beginValidation() {
    }

    @Override
    public void endValidation() {
    }

    @Override
    public void flush(Monitor monitor) {
    }

    @Override
    public void setParser(AbstractParser parser) {
        this.parser = parser;
    }

    @Override
    public AbstractParser getParser() {
        return this.parser;
    }

    @Override
    public void handleProblem(ProblemHandler.Severity problemSeverity, ProblemHandler.Phase processingPhase, String problemMessage, String processingContext, int startOffset, int endOffset) {
        String lineNumberObject = Integer.toString(this.parser.getIPrsStream().getTokenAtCharacter(startOffset).getLine());
        String processingPhaseObject = processingPhase != null ? processingPhase.toString() : "?";
        String problemSeverityObject = problemSeverity != null ? problemSeverity.toString() : "?";
        String processingContextObject = processingContext != null ? processingContext : "?";
        String problemMessageObject = problemMessage != null ? problemMessage : "?";
        String message = OCLMessages.bind(OCLMessages.ProblemMessage_ERROR_, new Object[]{processingPhaseObject, problemSeverityObject, processingContextObject, lineNumberObject, problemMessageObject});
        this.addProblem(message);
    }

    @Override
    public void lexerProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.LEXER, problemMessage, processingContext, startOffset, endOffset);
    }

    @Override
    public void parserProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.PARSER, problemMessage, processingContext, startOffset, endOffset);
    }

    @Override
    public void utilityProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.UTILITY, problemMessage, processingContext, startOffset, endOffset);
    }

    @Override
    public void validatorProblem(ProblemHandler.Severity problemSeverity, String problemMessage, String processingContext, int startOffset, int endOffset) {
        this.handleProblem(problemSeverity, ProblemHandler.Phase.VALIDATOR, problemMessage, processingContext, startOffset, endOffset);
    }

    @Override
    public void setErrorReportLineOffset(int offset) {
        this.errorReportLineOffset = offset;
    }

    @Override
    public int getErrorReportLineOffset() {
        return this.errorReportLineOffset;
    }
}

