/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.equinox;

import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.passage.lic.api.FeatureIdentifier;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.equinox.EquinoxPassage;

public abstract class LicensedRunnable
implements Runnable {
    private final FeatureIdentifier feature;
    private final Runnable action;
    private final Consumer<ServiceInvocationResult<GrantLockAttempt>> fallback;

    protected LicensedRunnable(FeatureIdentifier feature, Runnable action, Consumer<ServiceInvocationResult<GrantLockAttempt>> fallback) {
        this.feature = feature;
        this.action = action;
        this.fallback = fallback;
    }

    public LicensedRunnable(FeatureIdentifier feature, Runnable action) {
        this(feature, action, response -> {});
    }

    @Override
    public final void run() {
        Optional<ServiceInvocationResult<GrantLockAttempt>> response = Optional.empty();
        try {
            response = Optional.of(this.acquireLicense(this.feature));
            if (this.grantAcquired(response)) {
                this.action.run();
            } else {
                this.fallback.accept(response.get());
            }
        }
        finally {
            response.flatMap(ServiceInvocationResult::data).ifPresent(new EquinoxPassage()::releaseLicense);
        }
    }

    private boolean grantAcquired(Optional<ServiceInvocationResult<GrantLockAttempt>> response) {
        return response.flatMap(ServiceInvocationResult::data).map(GrantLockAttempt::successful).orElse(false);
    }

    protected abstract ServiceInvocationResult<GrantLockAttempt> acquireLicense(FeatureIdentifier var1);

    public static final class Default
    extends LicensedRunnable {
        public Default(FeatureIdentifier feature, Runnable action) {
            super(feature, action);
        }

        public Default(FeatureIdentifier feature, Runnable action, Consumer<ServiceInvocationResult<GrantLockAttempt>> fallback) {
            super(feature, action, fallback);
        }

        @Override
        protected ServiceInvocationResult<GrantLockAttempt> acquireLicense(FeatureIdentifier feature) {
            return new EquinoxPassage().acquireLicense(feature);
        }
    }
}

