/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.validators;

import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.validators.ISystemValidator;

public class ValidatorSpecialChar
implements ISystemValidator {
    public static final boolean EMPTY_ALLOWED_NO = false;
    public static final boolean EMPTY_ALLOWED_YES = true;
    private boolean isEmptyAllowed = true;
    protected StringBuffer specialChars;
    protected SystemMessage msg_Invalid;
    protected SystemMessage msg_Empty;
    protected SystemMessage currentMessage;
    private int nbrSpecialChars;

    public ValidatorSpecialChar(String specialChars, boolean isEmptyAllowed) {
        this(specialChars, isEmptyAllowed, RSEUIPlugin.getPluginMessage("RSEG1031"), RSEUIPlugin.getPluginMessage("RSEG1029"));
    }

    public ValidatorSpecialChar(String specialChars, boolean isEmptyAllowed, SystemMessage msg_Invalid) {
        this(specialChars, isEmptyAllowed, msg_Invalid, RSEUIPlugin.getPluginMessage("RSEG1029"));
    }

    public ValidatorSpecialChar(String specialChars, boolean isEmptyAllowed, SystemMessage msg_Invalid, SystemMessage msg_Empty) {
        this.isEmptyAllowed = isEmptyAllowed;
        this.specialChars = new StringBuffer(specialChars);
        this.nbrSpecialChars = specialChars.length();
        this.setErrorMessages(msg_Empty, msg_Invalid);
    }

    public void setErrorMessages(SystemMessage msg_Empty, SystemMessage msg_Invalid) {
        if (msg_Empty != null) {
            this.msg_Empty = msg_Empty;
        }
        if (msg_Invalid != null) {
            this.msg_Invalid = msg_Invalid;
        }
    }

    protected String doMessageSubstitution(SystemMessage msg, String substitution) {
        this.currentMessage = msg;
        if (msg.getNumSubstitutionVariables() > 0) {
            return msg.makeSubstitution((Object)substitution).getLevelOneText();
        }
        return msg.getLevelOneText();
    }

    protected String getSystemMessageText(SystemMessage msg) {
        this.currentMessage = msg;
        if (msg != null) {
            return msg.getLevelOneText();
        }
        return null;
    }

    public String isValid(String newText) {
        this.currentMessage = null;
        if (newText == null || newText.length() == 0) {
            if (this.isEmptyAllowed) {
                return null;
            }
            this.currentMessage = this.msg_Empty;
        } else {
            this.currentMessage = this.containsSpecialCharacters(newText) ? this.msg_Invalid : this.isSyntaxOk(newText);
        }
        return this.currentMessage == null ? null : this.doMessageSubstitution(this.currentMessage, newText);
    }

    public String isValid(Object newValue) {
        if (newValue instanceof String) {
            return this.isValid((String)newValue);
        }
        return null;
    }

    protected boolean containsSpecialCharacters(String newText) {
        boolean contains = false;
        int newLen = newText.length();
        int idx = 0;
        while (!contains && idx < newLen) {
            int jdx = 0;
            while (!contains && jdx < this.nbrSpecialChars) {
                if (newText.charAt(idx) == this.specialChars.charAt(jdx)) {
                    contains = true;
                }
                ++jdx;
            }
            ++idx;
        }
        return contains;
    }

    public SystemMessage isSyntaxOk(String newText) {
        return null;
    }

    public int getMaximumNameLength() {
        return -1;
    }

    public SystemMessage getSystemMessage() {
        return this.currentMessage;
    }

    public SystemMessage validate(String text) {
        if (this.isValid(text) != null) {
            return this.currentMessage;
        }
        return null;
    }
}

