/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.editor.tools.internal.menu.refactoring;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.editor.tools.internal.menu.refactoring.EdgeMappingDomainBasedCommand;
import org.eclipse.sirius.editor.tools.api.menu.AbstractEObjectRefactoringAction;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EdgeMappingRefactoringAction
extends AbstractEObjectRefactoringAction {
    private static final String TEXT_IF_DISABLE = "Move to Element-Based/Relation-Based Edge";

    public EdgeMappingRefactoringAction(IEditorPart editor, ISelection selection) {
        super(editor, selection);
    }

    protected Command buildActionCommand(EditingDomain arg0, Collection<EObject> selection) {
        EObject elementToUpdate;
        Object result = UnexecutableCommand.INSTANCE;
        this.setSelectionValid(false);
        if (selection.size() == 1 && (elementToUpdate = selection.iterator().next()) instanceof EdgeMapping) {
            this.setSelectionValid(true);
            this.setTextIfDisable(TEXT_IF_DISABLE);
            result = new EdgeMappingDomainBasedCommand(arg0.getResourceSet(), elementToUpdate);
        }
        return result;
    }

    public static void forceNotification(EdgeMapping elementToUpdate) {
        String name = elementToUpdate.getName();
        elementToUpdate.setName("_refactoring");
        elementToUpdate.setName(name);
        EdgeMappingRefactoringAction.refreshSelection((DiagramElementMapping)elementToUpdate);
    }

    public static void refreshSelection(DiagramElementMapping elementMapping) {
        ISelectionProvider selectionProvider;
        Option<ISelectionProvider> activeSiteSelectionProvider = EdgeMappingRefactoringAction.getActiveSiteSelectionProvider();
        if (activeSiteSelectionProvider.some() && (selectionProvider = (ISelectionProvider)activeSiteSelectionProvider.get()).getSelection() instanceof TreeSelection) {
            TreeSelection newSelection = new TreeSelection(((TreeSelection)selectionProvider.getSelection()).getPathsFor((Object)elementMapping));
            selectionProvider.setSelection((ISelection)newSelection);
        }
    }

    private static Option<ISelectionProvider> getActiveSiteSelectionProvider() {
        ISelectionProvider selectionProvider;
        Option<IWorkbenchPartSite> site = EdgeMappingRefactoringAction.getSite();
        if (site.some() && (selectionProvider = ((IWorkbenchPartSite)site.get()).getSelectionProvider()) != null) {
            return Options.newSome((Object)selectionProvider);
        }
        return Options.newNone();
    }

    private static Option<IWorkbenchPartSite> getSite() {
        IWorkbenchPart activePart;
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null && (activePart = activePage.getActivePart()) != null) {
            return Options.fromNullable((Object)activePart.getSite());
        }
        return Options.newNone();
    }
}

