/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.ui.contentproviders;

import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.wb.internal.swing.databinding.Messages;
import org.eclipse.wb.internal.swing.databinding.model.properties.ElPropertyInfo;
import org.eclipse.wb.internal.swing.databinding.model.properties.PropertyInfo;
import org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiConfiguration;

public final class ElPropertyUiContentProvider
extends org.eclipse.wb.internal.swing.databinding.ui.contentproviders.el.ElPropertyUiContentProvider {
    private ElPropertyInfo m_property;

    public ElPropertyUiContentProvider(ElPropertyUiConfiguration configuration, ElPropertyInfo property) {
        super(configuration);
        this.m_property = property;
        this.setEnabled(this.m_property != null);
    }

    public ElPropertyInfo getProperty() {
        return this.m_property;
    }

    public void setProperty(ElPropertyInfo property) throws Exception {
        this.m_property = property;
        this.setEnabled(this.m_property != null);
        if (this.m_property == null) {
            this.setText(Messages.ElPropertyUiContentProvider_0);
        } else {
            this.updateFromObject();
        }
    }

    @Override
    public void createContent(Composite parent, int columns) {
        super.createContent(parent, columns);
        this.m_sourceViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                ElPropertyUiContentProvider.this.calculateFinish();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    @Override
    public Class<?> getTopLevelBean() throws Exception {
        if (this.m_property == null) {
            return null;
        }
        PropertyInfo baseProperty = this.m_property.getBaseProperty();
        if (baseProperty != null) {
            return baseProperty.getValueType().getRawType();
        }
        return this.m_property.getSourceObjectType().getRawType();
    }

    public void calculateFinish() {
        if (this.getText().length() == 0) {
            this.setErrorMessage(Messages.ElPropertyUiContentProvider_errEmpty);
        } else {
            this.setErrorMessage(null);
        }
    }

    public void updateFromObject() throws Exception {
        this.setText(this.m_property.getExpression());
    }

    public void saveToObject() throws Exception {
        this.m_property.setExpression(this.getText());
    }
}

