/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.hover.html;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.text.html.BrowserInformationControl;
import org.eclipse.jface.internal.text.html.BrowserInformationControlInput;
import org.eclipse.jface.internal.text.html.BrowserInput;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension4;
import org.eclipse.jface.text.IInputChangedListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.ui.XtextUIMessages;
import org.eclipse.xtext.ui.editor.IURIEditorOpener;
import org.eclipse.xtext.ui.editor.hover.IEObjectHoverProvider;
import org.eclipse.xtext.ui.editor.hover.html.IEObjectHoverDocumentationProvider;
import org.eclipse.xtext.ui.editor.hover.html.IXtextBrowserInformationControl;
import org.eclipse.xtext.ui.editor.hover.html.OpenBrowserUtil;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControl;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlAdapter;
import org.eclipse.xtext.ui.editor.hover.html.XtextBrowserInformationControlInput;
import org.eclipse.xtext.ui.editor.hover.html.XtextElementLinks;
import org.eclipse.xtext.ui.internal.Activator;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.util.Strings;

public class DefaultEObjectHoverProvider
implements IEObjectHoverProvider {
    private static final Logger LOG = Logger.getLogger(DefaultEObjectHoverProvider.class);
    @Inject
    private ILabelProvider labelProvider;
    @Inject
    private IEObjectHoverDocumentationProvider decoratedProvider;
    @Inject
    private IQualifiedNameProvider nameProvider;
    @Inject
    private IURIEditorOpener uriEditorOpener;
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.XtextEditorHover.styleSheetFileName")
    private String styleSheetFileName = "/XtextHoverStyleSheet.css";
    @Inject(optional=true)
    @Named(value="org.eclipse.xtext.ui.editor.hover.XtextEditorHover.font")
    private String fontSymbolicName = "org.eclipse.jdt.ui.javadocfont";
    @Inject
    private XtextElementLinks elementLinks;
    private static String fgStyleSheet;
    private IInformationControlCreator hoverControlCreator;
    private IInformationControlCreator presenterControlCreator;

    protected String getHoverInfoAsHtml(EObject o) {
        if (!this.hasHover(o)) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getFirstLine(o));
        String documentation = this.getDocumentation(o);
        if (documentation != null && documentation.length() > 0) {
            buffer.append("<p>");
            buffer.append(documentation);
            buffer.append("</p>");
        }
        return buffer.toString();
    }

    protected XtextBrowserInformationControlInput getHoverInfo(EObject element, IRegion hoverRegion, XtextBrowserInformationControlInput previous) {
        String html = this.getHoverInfoAsHtml(element);
        if (html != null) {
            StringBuilder builder = new StringBuilder(html);
            ColorRegistry registry = JFaceResources.getColorRegistry();
            RGB fgRGB = registry.getRGB("org.eclipse.ui.workbench.HOVER_FOREGROUND");
            RGB bgRGB = registry.getRGB("org.eclipse.ui.workbench.HOVER_BACKGROUND");
            if (fgRGB != null && bgRGB != null) {
                HTMLPrinter.insertPageProlog((StringBuilder)builder, (int)0, (RGB)fgRGB, (RGB)bgRGB, (String)this.getStyleSheet());
            } else {
                HTMLPrinter.insertPageProlog((StringBuilder)builder, (int)0, (String)this.getStyleSheet());
            }
            HTMLPrinter.addPageEpilog((StringBuilder)builder);
            html = builder.toString();
            return new XtextBrowserInformationControlInput(previous, element, html, this.labelProvider);
        }
        return null;
    }

    protected boolean hasHover(EObject o) {
        return this.nameProvider.getFullyQualifiedName(o) != null;
    }

    protected String getDocumentation(EObject o) {
        return this.decoratedProvider.getDocumentation(o);
    }

    protected String getFirstLine(EObject o) {
        String label = this.getLabel(o);
        return o.eClass().getName() + (String)(label != null ? " <b>" + label + "</b>" : "");
    }

    protected String getLabel(EObject o) {
        String text = this.getLabelProvider().getText((Object)o);
        if (!Strings.isEmpty((String)text)) {
            return HTMLPrinter.convertToHTMLContent((String)text);
        }
        return null;
    }

    protected ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    protected XtextElementLinks getElementLinks() {
        return this.elementLinks;
    }

    protected URI createURI(EObject o) {
        return o.eResource().getURI().appendFragment(o.eResource().getURIFragment(o));
    }

    protected void addLinkListener(BrowserInformationControl control) {
        this.addLinkListener(new XtextBrowserInformationControlAdapter(control));
    }

    protected void addLinkListener(final IXtextBrowserInformationControl control) {
        control.addLocationListener(this.elementLinks.createLocationListener(new XtextElementLinks.ILinkHandler(){

            @Override
            public void handleXtextdocViewLink(URI linkTarget) {
            }

            @Override
            public void handleInlineXtextdocLink(URI linkTarget) {
                XtextBrowserInformationControlInput hoverInfo = DefaultEObjectHoverProvider.this.getHoverInfo(this.getTarget(linkTarget), null, (XtextBrowserInformationControlInput)control.getInput());
                if (control.hasDelayedInputChangeListener()) {
                    control.notifyDelayedInputChange((Object)hoverInfo);
                } else {
                    control.setInput((Object)hoverInfo);
                }
            }

            @Override
            public void handleDeclarationLink(URI linkTarget) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                if (DefaultEObjectHoverProvider.this.uriEditorOpener != null) {
                    DefaultEObjectHoverProvider.this.uriEditorOpener.open(linkTarget, true);
                }
            }

            @Override
            public boolean handleExternalLink(URL url, Display display) {
                control.notifyDelayedInputChange(null);
                control.dispose();
                OpenBrowserUtil.openExternal(url, display);
                return true;
            }

            @Override
            public void handleTextSet() {
            }

            EObject getTarget(URI uri) {
                ResourceSet rs = ((XtextBrowserInformationControlInput)control.getInput()).getElement().eResource().getResourceSet();
                return rs.getEObject(uri, true);
            }
        }));
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.presenterControlCreator == null) {
            this.presenterControlCreator = new PresenterControlCreator();
        }
        return this.presenterControlCreator;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.hoverControlCreator == null) {
            this.hoverControlCreator = new HoverControlCreator(this.getInformationPresenterControlCreator());
        }
        return this.hoverControlCreator;
    }

    protected String getStyleSheet() {
        String css;
        if (fgStyleSheet == null) {
            fgStyleSheet = this.loadStyleSheet();
        }
        if ((css = fgStyleSheet) != null) {
            FontData fontData = JFaceResources.getFontRegistry().getFontData(this.fontSymbolicName)[0];
            css = HTMLPrinter.convertTopLevelFont((String)css, (FontData)fontData);
        }
        return css;
    }

    /*
     * Loose catch block
     */
    protected String loadStyleSheet() {
        URL styleSheetURL = Activator.getDefault().getBundle().getEntry(this.styleSheetFileName);
        if (styleSheetURL != null) {
            BufferedReader reader = null;
            reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(1500);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            String string = buffer.toString();
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return string;
            catch (IOException ex) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return "";
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        return null;
    }

    @Override
    public IEObjectHoverProvider.IInformationControlCreatorProvider getHoverInfo(final EObject object, ITextViewer viewer, final IRegion region) {
        return new IEObjectHoverProvider.IInformationControlCreatorProvider2(){

            @Override
            public IInformationControlCreator getHoverControlCreator() {
                return DefaultEObjectHoverProvider.this.getHoverControlCreator();
            }

            @Override
            public Object getInfo() {
                try {
                    return DefaultEObjectHoverProvider.this.getHoverInfo(object, region, null);
                }
                catch (RuntimeException e) {
                    LOG.error((Object)("Error on computation of hover information. No hover information available for " + String.valueOf(object) + " at " + String.valueOf(region)), (Throwable)e);
                    return null;
                }
            }

            @Override
            public IInformationControlCreator getInformationPresenterControlCreator() {
                return DefaultEObjectHoverProvider.this.getInformationPresenterControlCreator();
            }
        };
    }

    protected int getDisposeHoverTimeout() {
        String key = "disposeClosedBrowserHoverTimeout";
        int timeout = Platform.getPreferencesService().getInt("org.eclipse.ui", key, -1, null);
        return timeout;
    }

    protected static final class BackAction
    extends Action {
        private final IXtextBrowserInformationControl fInfoControl;

        public BackAction(IXtextBrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(XtextUIMessages.XtextBrowserInformationControlInput_Back);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_BACK_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput previous = (BrowserInformationControlInput)this.fInfoControl.getInput().getPrevious();
            if (previous != null) {
                this.fInfoControl.setInput(previous);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getPrevious() != null) {
                BrowserInput previous = current.getPrevious();
                this.setToolTipText(MessageFormat.format(XtextUIMessages.XtextBrowserInformationControlInput_BackTo, previous.getInputName()));
                this.setEnabled(true);
            } else {
                this.setToolTipText(XtextUIMessages.XtextBrowserInformationControlInput_Back);
                this.setEnabled(false);
            }
        }
    }

    protected static final class ForwardAction
    extends Action {
        private final IXtextBrowserInformationControl fInfoControl;

        public ForwardAction(IXtextBrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(XtextUIMessages.XtextBrowserInformationControlInput_Forward);
            ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
            this.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD"));
            this.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_FORWARD_DISABLED"));
            this.update();
        }

        public void run() {
            BrowserInformationControlInput next = (BrowserInformationControlInput)this.fInfoControl.getInput().getNext();
            if (next != null) {
                this.fInfoControl.setInput(next);
            }
        }

        public void update() {
            BrowserInformationControlInput current = this.fInfoControl.getInput();
            if (current != null && current.getNext() != null) {
                this.setToolTipText(MessageFormat.format(XtextUIMessages.XtextBrowserInformationControlInput_ForwardTo, current.getNext().getInputName()));
                this.setEnabled(true);
            } else {
                this.setToolTipText(XtextUIMessages.XtextBrowserInformationControlInput_Forward);
                this.setEnabled(false);
            }
        }
    }

    public class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private final IInformationControlCreator fInformationPresenterControlCreator;

        public HoverControlCreator(IInformationControlCreator informationPresenterControlCreator) {
            this.fInformationPresenterControlCreator = informationPresenterControlCreator;
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                String font = "org.eclipse.jdt.ui.javadocfont";
                XtextBrowserInformationControl iControl = new XtextBrowserInformationControl(parent, font, tooltipAffordanceString){

                    public IInformationControlCreator getInformationPresenterControlCreator() {
                        return HoverControlCreator.this.fInformationPresenterControlCreator;
                    }
                };
                iControl.setDisposeTimeout(DefaultEObjectHoverProvider.this.getDisposeHoverTimeout());
                DefaultEObjectHoverProvider.this.addLinkListener(iControl);
                return iControl;
            }
            return new DefaultInformationControl(parent, tooltipAffordanceString);
        }

        public boolean canReuse(IInformationControl control) {
            if (!super.canReuse(control)) {
                return false;
            }
            if (control instanceof IInformationControlExtension4) {
                String tooltipAffordanceString = EditorsUI.getTooltipAffordanceString();
                ((IInformationControlExtension4)control).setStatusText(tooltipAffordanceString);
            }
            return true;
        }
    }

    protected class OpenDeclarationAction
    extends Action {
        private final IXtextBrowserInformationControl fInfoControl;

        public OpenDeclarationAction(IXtextBrowserInformationControl infoControl) {
            this.fInfoControl = infoControl;
            this.setText(XtextUIMessages.XtextBrowserInformationControlInput_OpenDeclaration);
            this.setImageDescriptor(XtextPluginImages.DESC_OPEN_DECLARATION);
            this.setDisabledImageDescriptor(XtextPluginImages.DESC_OPEN_DECLARATION_DISABLED);
        }

        public void run() {
            if (this.fInfoControl.getInput() instanceof XtextBrowserInformationControlInput) {
                XtextBrowserInformationControlInput infoInput = (XtextBrowserInformationControlInput)this.fInfoControl.getInput();
                this.fInfoControl.notifyDelayedInputChange(null);
                this.fInfoControl.dispose();
                if (DefaultEObjectHoverProvider.this.uriEditorOpener != null) {
                    DefaultEObjectHoverProvider.this.uriEditorOpener.open(DefaultEObjectHoverProvider.this.createURI(infoInput.getElement()), true);
                }
            }
        }
    }

    public class PresenterControlCreator
    extends AbstractReusableInformationControlCreator {
        public IInformationControl doCreateInformationControl(Shell parent) {
            if (BrowserInformationControl.isAvailable((Composite)parent)) {
                ToolBarManager tbm = new ToolBarManager(0x800000);
                String font = "org.eclipse.jdt.ui.javadocfont";
                XtextBrowserInformationControl control = new XtextBrowserInformationControl(parent, font, tbm);
                control.setDisposeTimeout(DefaultEObjectHoverProvider.this.getDisposeHoverTimeout());
                this.configureControl(control, tbm, font);
                return control;
            }
            return new DefaultInformationControl(parent, true);
        }

        protected void configureControl(IXtextBrowserInformationControl control, ToolBarManager tbm, String font) {
            final BackAction backAction = new BackAction(control);
            backAction.setEnabled(false);
            tbm.add((IAction)backAction);
            final ForwardAction forwardAction = new ForwardAction(control);
            tbm.add((IAction)forwardAction);
            forwardAction.setEnabled(false);
            final OpenDeclarationAction openDeclarationAction = new OpenDeclarationAction(control);
            tbm.add((IAction)openDeclarationAction);
            IInputChangedListener inputChangeListener = new IInputChangedListener(){

                public void inputChanged(Object newInput) {
                    backAction.update();
                    forwardAction.update();
                    if (newInput != null && newInput instanceof XtextBrowserInformationControlInput) {
                        openDeclarationAction.setEnabled(true);
                    }
                }
            };
            control.addInputChangeListener(inputChangeListener);
            tbm.update(true);
            DefaultEObjectHoverProvider.this.addLinkListener(control);
        }
    }
}

