/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.pror.editor.presentation.service;

import java.util.Map;
import org.eclipse.rmf.reqif10.pror.configuration.ProrPresentationConfiguration;
import org.eclipse.rmf.reqif10.pror.configuration.impl.ProrPresentationConfigurationImpl;
import org.eclipse.rmf.reqif10.pror.edit.presentation.service.PresentationInterface;
import org.eclipse.rmf.reqif10.pror.editor.presentation.service.PresentationServiceManager;
import org.eclipse.rmf.reqif10.pror.presentation.headline.HeadlineConfiguration;
import org.eclipse.rmf.reqif10.pror.presentation.headline.HeadlineFactory;
import org.eclipse.rmf.reqif10.pror.presentation.headline.ui.HeadlinePresentationService;
import org.eclipse.rmf.reqif10.pror.presentation.id.IdConfiguration;
import org.eclipse.rmf.reqif10.pror.presentation.id.IdFactory;
import org.eclipse.rmf.reqif10.pror.presentation.linewrap.LinewrapConfiguration;
import org.eclipse.rmf.reqif10.pror.presentation.linewrap.LinewrapFactory;
import org.eclipse.rmf.reqif10.pror.presentation.ui.IdPresentationService;
import org.eclipse.rmf.reqif10.pror.presentation.ui.LinewrapPresentationService;
import org.junit.Assert;
import org.junit.Test;

public class PresentationServiceManagerTest {
    @Test
    public void testGetPresentationServiceMapContent() {
        Map map = PresentationServiceManager.getPresentationInterfaceMap();
        Assert.assertEquals((long)3L, (long)map.size());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testPresentationMapNotModifyable() {
        PresentationServiceManager.getPresentationInterfaceMap().clear();
    }

    @Test
    public void testHeadlinePresentationService() {
        HeadlineConfiguration config = HeadlineFactory.eINSTANCE.createHeadlineConfiguration();
        PresentationInterface service = PresentationServiceManager.getPresentationService((ProrPresentationConfiguration)config);
        Assert.assertTrue((boolean)(service instanceof HeadlinePresentationService));
    }

    @Test
    public void testIdPresentationService() {
        IdConfiguration config = IdFactory.eINSTANCE.createIdConfiguration();
        PresentationInterface service = PresentationServiceManager.getPresentationService((ProrPresentationConfiguration)config);
        Assert.assertTrue((boolean)(service instanceof IdPresentationService));
    }

    @Test
    public void testLinewrapPresentationService() {
        LinewrapConfiguration config = LinewrapFactory.eINSTANCE.createLinewrapConfiguration();
        PresentationInterface service = PresentationServiceManager.getPresentationService((ProrPresentationConfiguration)config);
        Assert.assertTrue((boolean)(service instanceof LinewrapPresentationService));
    }

    @Test
    public void testMissingPresentationService() {
        ProrPresentationConfigurationImpl config = new ProrPresentationConfigurationImpl(){

            public void registerReqIF() {
            }

            public void unregisterReqIF() {
            }
        };
        PresentationInterface service = PresentationServiceManager.getPresentationService((ProrPresentationConfiguration)config);
        Assert.assertNull((Object)service);
    }
}

