/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import java.util.Hashtable;
import org.agilemore.agilegrid.AbstractLayoutAdvisor;
import org.agilemore.agilegrid.AgileGrid;

public class DefaultLayoutAdvisor
extends AbstractLayoutAdvisor {
    private Hashtable<Integer, Integer> rowHeights = new Hashtable();
    protected Hashtable<Integer, Integer> colWidths = new Hashtable();
    protected int leftHeaderWidth = 35;
    protected int topHeaderHeight = 18;

    public DefaultLayoutAdvisor(AgileGrid agileGrid) {
        super(agileGrid);
    }

    public int getColumnWidth(int col) {
        Integer width = this.colWidths.get(new Integer(col));
        if (width == null) {
            int initWidth = this.getInitialColumnWidth(col);
            if (initWidth < 0) {
                return 0;
            }
            return initWidth;
        }
        return width;
    }

    protected void doSetColumnWidth(int col, int width) {
        if (width < 0) {
            width = 0;
        }
        this.colWidths.put(new Integer(col), new Integer(width));
    }

    protected void doSetRowHeight(int row, int height) {
        if (height < 0) {
            height = 0;
        }
        this.rowHeights.put(new Integer(row), new Integer(height));
    }

    public int getRowHeight(int row) {
        Integer height = this.rowHeights.get(new Integer(row));
        if (height == null) {
            int h;
            if (row == 0 && (h = this.getInitialRowHeight(0)) > 2) {
                return h;
            }
            int initialH = this.getInitialRowHeight(row);
            if (initialH < 2) {
                return 2;
            }
            return initialH;
        }
        if (height < 2) {
            return 2;
        }
        return height;
    }

    public int getInitialColumnWidth(int column) {
        return 80;
    }

    public int getInitialRowHeight(int row) {
        return 18;
    }

    public int getFixedColumnCount() {
        return 0;
    }

    public int getFixedRowCount() {
        return 0;
    }

    public int getRowHeightMinimum() {
        return 0;
    }

    public boolean isColumnResizable(int col) {
        return true;
    }

    public boolean isRowResizable(int row) {
        return true;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return 6;
    }

    public int getLeftHeaderWidth() {
        return this.leftHeaderWidth;
    }

    public int getTopHeaderHeight() {
        return this.topHeaderHeight;
    }

    public boolean isLeftHeaderVisible() {
        return true;
    }

    public boolean isTopHeaderVisible() {
        return true;
    }

    public String getLeftHeaderLabel(int row) {
        return Integer.toString(row);
    }

    public String getTopHeaderLabel(int col) {
        String result = "";
        while (col >= 0) {
            result = String.valueOf((char)((char)(col % 26) + 65)) + result;
            col = col / 26 - 1;
        }
        return result;
    }

    protected void doSetColumnCount(int columnCount) {
    }

    protected void doSetFixedColumnCount(int fixedColumnCount) {
    }

    protected void doSetFixedRowCount(int fixedRowCount) {
    }

    protected void doSetLeftHeaderLabel(int row, String label) {
    }

    protected void doSetLeftHeaderVisible(boolean visible) {
    }

    protected void doSetLeftHeaderWidth(int width) {
        this.leftHeaderWidth = width;
    }

    protected void doSetRowCount(int rowCount) {
    }

    protected void doSetRowHeightMinimum(int minimumHeight) {
    }

    protected void doSetRowResizable(int row, boolean resizable) {
    }

    protected void doSetTooltipAt(int row, int col, String tooltip) {
    }

    protected void doSetTopHeaderHeight(int height) {
        this.topHeaderHeight = height;
    }

    protected void doSetTopHeaderLabel(int col, String label) {
    }

    protected void doSetTopHeaderVisible(boolean visible) {
    }

    public String getTooltip(int row, int col) {
        return null;
    }

    public void setColumnResizable(int col, boolean resizable) {
    }
}

