/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rmf.reqif10.search.filter.ui;

import java.math.BigInteger;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

class NumberControl {
    private boolean isReal;
    private Text text;

    public NumberControl(Composite parent, boolean isReal) {
        this.text = new Text(parent, 2052);
        this.isReal = isReal;
        this.text.setText("0");
        this.addValidator();
    }

    public Text getControl() {
        return this.text;
    }

    private void addValidator() {
        this.text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String oldS = NumberControl.this.text.getText();
                String newS = String.valueOf(oldS.substring(0, e.start)) + e.text + oldS.substring(e.end);
                if (newS.length() == 0) {
                    return;
                }
                try {
                    if (NumberControl.this.isReal) {
                        new Double(newS);
                    } else {
                        new BigInteger(newS);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    e.doit = false;
                }
            }
        });
    }

    public Number getNumber() {
        if (this.text.getText().length() == 0) {
            this.text.setText("0");
        }
        return this.isReal ? new Double(this.text.getText()) : new BigInteger(this.text.getText());
    }

    public void setValue(Number value) {
        this.text.setText(value.toString());
    }
}

