/*
 * Decompiled with CFR 0.152.
 */
package org.agilemore.agilegrid;

import org.agilemore.agilegrid.AgileGrid;
import org.agilemore.agilegrid.Cell;
import org.agilemore.agilegrid.CellEditor;
import org.agilemore.agilegrid.ICellEditorProvider;
import org.agilemore.agilegrid.ICellRenderer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class AbstractCellEditorProvider
implements ICellEditorProvider {
    protected AgileGrid agileGrid;
    private Control smartToolBar;
    protected Cell currentCell;

    public AbstractCellEditorProvider(AgileGrid agileGrid) {
        this(agileGrid, false);
    }

    public AbstractCellEditorProvider(AgileGrid agileGrid, boolean enableSmartToolBar) {
        this.agileGrid = agileGrid;
        if (enableSmartToolBar) {
            this.hookListeners(agileGrid);
        }
    }

    @Override
    public abstract CellEditor getCellEditor(int var1, int var2);

    @Override
    public abstract boolean canEdit(int var1, int var2);

    public AgileGrid getAgileGrid() {
        return this.agileGrid;
    }

    @Override
    public void initializeCellEditorValue(CellEditor cellEditor, Cell cell) {
        Object value = this.getValue(cell.row, cell.column);
        cellEditor.setValue(value);
    }

    @Override
    public void saveCellEditorValue(CellEditor cellEditor, Cell cell) {
        if (cellEditor.isValueValid()) {
            Object value = cellEditor.getValue();
            this.setValue(cell.row, cell.column, value);
        }
    }

    public abstract Object getValue(int var1, int var2);

    public abstract void setValue(int var1, int var2, Object var3);

    protected void processSmartToolBar(Cell cell) {
        if (!this.showSmartToolBar(cell)) {
            if (this.smartToolBar != null && !this.smartToolBar.isDisposed()) {
                this.smartToolBar.dispose();
                this.smartToolBar = null;
            }
            return;
        }
        if (this.smartToolBar == null || this.smartToolBar.isDisposed()) {
            this.smartToolBar = this.createSmartToolBar((Composite)this.agileGrid);
            if (this.smartToolBar == null) {
                return;
            }
            this.smartToolBar.setVisible(false);
        }
        Rectangle cellRect = this.agileGrid.getCellRect(cell.row, cell.column);
        Point containerSize = this.smartToolBar.getSize();
        cellRect.x = cellRect.x + cellRect.width - containerSize.x - 1;
        ++cellRect.y;
        Cell focusCell = this.agileGrid.getFocusCell();
        if (focusCell.equals(cell) || (this.agileGrid.getStyle() & 0x8000000) == 0x8000000 && focusCell.row == cell.row) {
            this.smartToolBar.setBackground(ICellRenderer.COLOR_BGSELECTION);
        } else {
            this.smartToolBar.setBackground(ICellRenderer.COLOR_BACKGROUND);
        }
        this.smartToolBar.setLocation(cellRect.x, cellRect.y);
        this.smartToolBar.setVisible(true);
    }

    protected void hookListeners(final AgileGrid agileGrid) {
        Listener smartToolBarListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        AbstractCellEditorProvider.this.currentCell = agileGrid.getFocusCell();
                        AbstractCellEditorProvider.this.processSmartToolBar(AbstractCellEditorProvider.this.currentCell);
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 12: 
                    case 13: 
                    case 32: {
                        AbstractCellEditorProvider.this.currentCell = agileGrid.getCell(event.x, event.y);
                        AbstractCellEditorProvider.this.processSmartToolBar(AbstractCellEditorProvider.this.currentCell);
                    }
                }
            }
        };
        agileGrid.addListener(12, smartToolBarListener);
        agileGrid.addListener(1, smartToolBarListener);
        agileGrid.addListener(3, smartToolBarListener);
        agileGrid.addListener(8, smartToolBarListener);
        agileGrid.addListener(5, smartToolBarListener);
        agileGrid.addListener(32, smartToolBarListener);
        agileGrid.addListener(7, smartToolBarListener);
    }

    protected abstract Composite createSmartToolBar(Composite var1);

    protected abstract boolean showSmartToolBar(Cell var1);
}

