/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.collab.share;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.osgi.util.NLS;

public class SharedObjectMsg
implements Serializable {
    static final long serialVersionUID = 571132189626558278L;
    public static final Object[] nullArgs = new Object[0];
    public static final Class[] nullTypes = new Class[0];
    String myClassName;
    String myMethodName;
    Object[] myArgs;

    public static SharedObjectMsg createMsg(String className, String methodName, Object[] param) {
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)param);
        return new SharedObjectMsg(className, methodName, param);
    }

    public static SharedObjectMsg createMsg(String methodName, Object[] param) {
        return SharedObjectMsg.createMsg(null, methodName, param);
    }

    public static SharedObjectMsg createMsg(String methodName) {
        return SharedObjectMsg.createMsg(null, methodName, nullArgs);
    }

    public static SharedObjectMsg createMsg(String className, String methodName) {
        return SharedObjectMsg.createMsg(className, methodName, nullArgs);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg) {
        Object[] args = new Object[]{arg};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String methodName, Object arg) {
        return SharedObjectMsg.createMsg(null, methodName, arg);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2, Object arg3, Object arg4) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static SharedObjectMsg createMsg(String className, String methodName, Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        Object[] args = new Object[]{arg1, arg2, arg3, arg4, arg5};
        return SharedObjectMsg.createMsg(className, methodName, args);
    }

    public static Class getClass(ClassLoader loader, String name) throws ClassNotFoundException {
        if (name == null) {
            return null;
        }
        return Class.forName(name, true, loader);
    }

    public static String getName(Class clazz) {
        return clazz.getName();
    }

    public static Class[] getArgTypes(Object[] args) {
        Class[] argTypes = null;
        if (args == null || args.length == 0) {
            argTypes = nullTypes;
        } else {
            argTypes = new Class[args.length];
            int i = 0;
            while (i < args.length) {
                argTypes[i] = args[i] == null ? null : args[i].getClass();
                ++i;
            }
        }
        return argTypes;
    }

    static Method findMethod(final Class clazz, String meth, Class[] args) {
        Method[] methods = null;
        try {
            methods = (Method[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return clazz.getDeclaredMethods();
                }
            });
        }
        catch (PrivilegedActionException e) {
            return null;
        }
        return SharedObjectMsg.searchForMethod(methods, meth, args);
    }

    public static Method searchForMethod(Method[] meths, String meth, Class[] args) {
        int i = 0;
        while (i < meths.length) {
            Method test = meths[i];
            if (test.getName().equals(meth) && test.getParameterTypes().length == args.length) {
                return test;
            }
            ++i;
        }
        return null;
    }

    public static Method findMethodRecursive(Class clazz, String meth, Class[] args) {
        Method aMethod = SharedObjectMsg.findMethod(clazz, meth, args);
        if (aMethod == null) {
            Class superclazz = clazz.getSuperclass();
            if (superclazz != null) {
                return SharedObjectMsg.findMethodRecursive(superclazz, meth, args);
            }
            return null;
        }
        return aMethod;
    }

    public static void checkForSerializable(SharedObjectMsg aMsg) throws NotSerializableException {
        Object[] args = aMsg.getArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i] != null && !(args[i] instanceof Serializable)) {
                throw new NotSerializableException(NLS.bind((String)Messages.SharedObjectMsg_EXCEPTION_NOT_SERIALIZABLE, (Object)new Integer(i)));
            }
            ++i;
        }
    }

    SharedObjectMsg(String className, String methodName, Object[] args) {
        this.myClassName = className;
        this.myMethodName = methodName;
        this.myArgs = args;
    }

    SharedObjectMsg(String methodName) {
        this(null, methodName, null);
    }

    public final String getMethodName() {
        return this.myMethodName;
    }

    public final void setMethodName(String name) {
        this.checkAlterMsg();
        if (name == null) {
            throw new NullPointerException(Messages.SharedObjectMsg_EXCEPTION_METHOD_NOT_NULL);
        }
        this.myMethodName = name;
    }

    protected void checkAlterMsg() {
    }

    public final String getClassName() {
        return this.myClassName;
    }

    public final void setClassName(String name) {
        this.checkAlterMsg();
        this.myClassName = name;
    }

    public Object[] getArgs() {
        return this.myArgs;
    }

    public final void setArgs(Object[] args) {
        this.checkAlterMsg();
        this.myArgs = args == null ? nullArgs : args;
    }

    protected Class[] getArgTypes() {
        return SharedObjectMsg.getArgTypes(this.getArgs());
    }

    protected final Method findMethod(Class clazz) {
        return SharedObjectMsg.findMethod(clazz, this.getMethodName(), this.getArgTypes());
    }

    protected final Method findMethodRecursive(Class clazz) {
        return SharedObjectMsg.findMethodRecursive(clazz, this.getMethodName(), this.getArgTypes());
    }

    public final Object invoke(Object target) throws Exception {
        return this.doInvoke(target);
    }

    Object doInvoke(Object target) throws Exception {
        if (target == null) {
            throw new NoSuchMethodException(Messages.SharedObjectMsg_EXCEPTION_NULL_TARGET);
        }
        Method meth = null;
        meth = this.myClassName == null ? this.findMethodRecursive(target.getClass()) : this.findMethod(SharedObjectMsg.getClass(target.getClass().getClassLoader(), this.myClassName));
        if (meth == null) {
            throw new NoSuchMethodException(this.getMethodName());
        }
        final Method toCall = meth;
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!toCall.isAccessible()) {
                    toCall.setAccessible(true);
                }
                return null;
            }
        });
        return toCall.invoke(target, this.getArgs());
    }

    public final Object invokeFrom(ID fromID, Object target) throws Exception {
        Object[] newParams = null;
        SenderID sender = new SenderID(fromID);
        Object[] args = this.getArgs();
        if (args == null) {
            newParams = new Object[]{sender};
        } else {
            newParams = new Object[this.myArgs.length + 1];
            newParams[0] = sender;
            System.arraycopy(args, 0, newParams, 1, args.length);
        }
        this.myArgs = newParams;
        return this.invoke(target);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("SharedObjectMsg[").append(this.myClassName).append(":").append(this.myMethodName).append("(");
        if (this.myArgs == null) {
            sb.append(this.myArgs);
        } else {
            int i = 0;
            while (i < this.myArgs.length) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(this.myArgs[i]);
                ++i;
            }
        }
        sb.append(")]");
        return sb.toString();
    }

    class SenderID {
        private final ID id;

        protected SenderID(ID theID) {
            this.id = theID;
        }

        public ID getID() {
            return this.id;
        }
    }
}

