/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.httpclient4;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.core.util.ProxyAddress;
import org.eclipse.ecf.core.util.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HttpClientProxyCredentialProvider
implements CredentialsProvider {
    private Map cachedCredentials = new ConcurrentHashMap();

    protected abstract Proxy getECFProxy();

    protected abstract Credentials getNTLMCredentials(Proxy var1);

    public void setCredentials(AuthScope authscope, Credentials credentials) {
        if (authscope == null) {
            throw new IllegalArgumentException("Authentication scope may not be null");
        }
        this.cachedCredentials.put(authscope, credentials);
    }

    public Credentials getCredentials(AuthScope authscope) {
        Trace.entering((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"org.eclipse.ecf.provider.filetransfer.httpclient4/debug/methods/entering", HttpClientProxyCredentialProvider.class, (String)("getCredentials " + authscope));
        Credentials result = HttpClientProxyCredentialProvider.matchCredentials(this.cachedCredentials, authscope);
        if (result != null) {
            return result;
        }
        Proxy proxy = this.getECFProxy();
        if (proxy == null) {
            return null;
        }
        if (!this.matchAuthScopeAndProxy(authscope, proxy)) {
            return null;
        }
        Credentials credentials = null;
        if ("ntlm".equalsIgnoreCase(authscope.getScheme())) {
            credentials = this.getNTLMCredentials(proxy);
        } else if ("basic".equalsIgnoreCase(authscope.getScheme()) || "digest".equalsIgnoreCase(authscope.getScheme())) {
            String proxyUsername = proxy.getUsername();
            String proxyPassword = proxy.getPassword();
            if (proxyUsername != null) {
                credentials = new UsernamePasswordCredentials(proxyUsername, proxyPassword);
            }
        } else if ("negotiate".equalsIgnoreCase(authscope.getScheme())) {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"SPNEGO is not supported, if you can contribute support, please do so.");
        } else {
            Trace.trace((String)"org.eclipse.ecf.provider.filetransfer.httpclient4", (String)"Unrecognized authentication scheme.");
        }
        if (credentials != null) {
            this.cachedCredentials.put(authscope, credentials);
        }
        return credentials;
    }

    private boolean matchAuthScopeAndProxy(AuthScope authscope, Proxy proxy) {
        ProxyAddress proxyAddress = proxy.getAddress();
        return authscope.getHost().equals(proxyAddress.getHostName()) && authscope.getPort() == proxyAddress.getPort();
    }

    private static Credentials matchCredentials(Map<AuthScope, Credentials> map, AuthScope authscope) {
        Credentials creds = map.get(authscope);
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScope bestMatch = null;
            for (AuthScope current : map.keySet()) {
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                creds = map.get(bestMatch);
            }
        }
        return creds;
    }

    public void clear() {
        this.cachedCredentials.clear();
    }
}

