/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.asyncproxy;

import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.concurrent.future.IFuture;
import org.eclipse.equinox.concurrent.future.IProgressRunnable;
import org.eclipse.equinox.concurrent.future.ImmediateExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncReturnUtil {
    public static boolean isAsyncType(Class<?> type) {
        return type == null ? false : Future.class.isAssignableFrom(type) || IFuture.class.isAssignableFrom(type);
    }

    public static boolean isAsyncType(String className) {
        return className == null ? false : Future.class.getName().equals(className) || IFuture.class.getName().equals(className);
    }

    public static Object convertAsyncToReturn(Object returnObject, Class<?> asyncReturnType, long timeout) throws InterruptedException, ExecutionException, TimeoutException, InvocationTargetException {
        if (returnObject == null) {
            return null;
        }
        if (asyncReturnType.isAssignableFrom(Future.class)) {
            return ((Future)returnObject).get(timeout, TimeUnit.MILLISECONDS);
        }
        if (asyncReturnType.isAssignableFrom(IFuture.class)) {
            return ((IFuture)returnObject).get();
        }
        return null;
    }

    private static IFuture<?> createIFuture(final Object returnObject) {
        return new ImmediateExecutor().execute((IProgressRunnable)new IProgressRunnable<Object>(){

            public Object run(IProgressMonitor monitor) throws Exception {
                return returnObject;
            }
        }, null);
    }

    private static Future<?> createFuture(final Object returnObject) {
        return Executors.newSingleThreadExecutor().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return returnObject;
            }
        });
    }

    public static Object convertReturnToAsync(Object returnObject, Class<?> returnType) {
        if (IFuture.class.isAssignableFrom(returnType)) {
            return AsyncReturnUtil.createIFuture(returnObject);
        }
        if (Future.class.isAssignableFrom(returnType)) {
            return AsyncReturnUtil.createFuture(returnObject);
        }
        return null;
    }

    public static Object convertReturnToAsync(Object returnObject, String returnType) {
        if (IFuture.class.getName().equals(returnType)) {
            return AsyncReturnUtil.createIFuture(returnObject);
        }
        if (Future.class.getName().equals(returnType)) {
            return AsyncReturnUtil.createFuture(returnObject);
        }
        return null;
    }
}

